/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.services;

import java.security.PrivateKey;
import java.security.Signature;
import org.apache.commons.codec.binary.Base64;
import org.scribe.exceptions.OAuthSignatureException;
import org.scribe.services.SignatureService;

public class RSASha1SignatureService
implements SignatureService {
    private static final String METHOD = "RSA-SHA1";
    private static final String RSA_SHA1 = "SHA1withRSA";
    private PrivateKey privateKey;

    public RSASha1SignatureService(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Signature signature = Signature.getInstance(RSA_SHA1);
            signature.initSign(this.privateKey);
            signature.update(baseString.getBytes());
            return new String(Base64.encodeBase64((byte[])signature.sign(), (boolean)false));
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    public String getSignatureMethod() {
        return METHOD;
    }
}

