#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cache.h"
#include "stats.h"

int verbose = 0;

void simulateAllTheSteps(FILE *tf) {
    unsigned addr;
    char rw;

    while (fscanf(tf, "%x %c", &addr, &rw) == 2) {

        int hit = simulateOneStep(addr, rw); // testar acesso a cache

        if (verbose) {
            if (hit)
                printf("%x %c (HIT)\n", addr, rw);
            else
                printf("%x %c (MISS)\n", addr, rw);
        }
    }
}

int main(int argc, char *argv[]) {
    FILE *traceFile;
    int nlines;
    char *prog = argv[0];

    if (argc > 1 && strcmp(argv[1], "-v") == 0) {
        verbose = 1;
        argc--;
        argv++;
    }
    if (argc < 2 || argc > 3) {
        /* Garantir que foram passados 2 a 4 argumentos
            na linha de comando */
        printf("%s [-v] num-cache-lines [tracefile] \n", prog);
        return 1;
    }

    /* numero de linhas na cache a simular*/
    nlines = atoi(argv[1]);
    if (nlines == 0) {
        printf("Cache with size zero?!\n");
        exit(1);
    }
    if (argc == 2)
        traceFile = stdin;
    else if ((traceFile = fopen(argv[2], "r")) == NULL) {
        printf("Trace-file '%s' error\n", argv[2]);
        exit(1);
    }

    initStats();
    initCache(nlines);
    simulateAllTheSteps(traceFile);
    printStats(argc == 2 ? "stdin" : argv[1]);
    return 0;
}
