/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class CircuitElm
implements Editable {
    static double voltageRange = 5.0;
    static int colorScaleCount = 32;
    static Color[] colorScale;
    static double currentMult;
    static double powerMult;
    static Point ps1;
    static Point ps2;
    static CirSim sim;
    static Color whiteColor;
    static Color selectColor;
    static Color lightGrayColor;
    static Font unitsFont;
    public static NumberFormat showFormat;
    public static NumberFormat shortFormat;
    public static NumberFormat noCommaFormat;
    static final double pi = Math.PI;
    int x;
    int y;
    int x2;
    int y2;
    int flags;
    int[] nodes;
    int voltSource;
    int dx;
    int dy;
    int dsign;
    double dn;
    double dpx1;
    double dpy1;
    Point point1;
    Point point2;
    Point lead1;
    Point lead2;
    double[] volts;
    double current;
    double curcount;
    Rectangle boundingBox;
    boolean noDiagonal;
    public boolean selected;

    int getDumpType() {
        return 0;
    }

    Class getDumpClass() {
        return this.getClass();
    }

    int getDefaultFlags() {
        return 0;
    }

    static void initClass(CirSim cirSim) {
        unitsFont = new Font("SansSerif", 0, 10);
        sim = cirSim;
        colorScale = new Color[colorScaleCount];
        for (int i = 0; i != colorScaleCount; ++i) {
            int n;
            int n2;
            double d = (double)i * 2.0 / (double)colorScaleCount - 1.0;
            if (d < 0.0) {
                n2 = (int)(128.0 * -d) + 127;
                n = (int)(127.0 * (1.0 + d));
                CircuitElm.colorScale[i] = new Color(n2, n, n);
                continue;
            }
            n2 = (int)(128.0 * d) + 127;
            n = (int)(127.0 * (1.0 - d));
            CircuitElm.colorScale[i] = new Color(n, n2, n);
        }
        ps1 = new Point();
        ps2 = new Point();
        showFormat = DecimalFormat.getInstance();
        showFormat.setMaximumFractionDigits(2);
        shortFormat = DecimalFormat.getInstance();
        shortFormat.setMaximumFractionDigits(1);
        noCommaFormat = DecimalFormat.getInstance();
        noCommaFormat.setMaximumFractionDigits(10);
        noCommaFormat.setGroupingUsed(false);
    }

    CircuitElm(int n, int n2) {
        this.x = this.x2 = n;
        this.y = this.y2 = n2;
        this.flags = this.getDefaultFlags();
        this.allocNodes();
        this.initBoundingBox();
    }

    CircuitElm(int n, int n2, int n3, int n4, int n5) {
        this.x = n;
        this.y = n2;
        this.x2 = n3;
        this.y2 = n4;
        this.flags = n5;
        this.allocNodes();
        this.initBoundingBox();
    }

    void initBoundingBox() {
        this.boundingBox = new Rectangle();
        this.boundingBox.setBounds(CircuitElm.min(this.x, this.x2), CircuitElm.min(this.y, this.y2), CircuitElm.abs(this.x2 - this.x) + 1, CircuitElm.abs(this.y2 - this.y) + 1);
    }

    void allocNodes() {
        this.nodes = new int[this.getPostCount() + this.getInternalNodeCount()];
        this.volts = new double[this.getPostCount() + this.getInternalNodeCount()];
    }

    String dump() {
        int n = this.getDumpType();
        return (n < 127 ? (char)n + " " : n + " ") + this.x + " " + this.y + " " + this.x2 + " " + this.y2 + " " + this.flags;
    }

    void reset() {
        for (int i = 0; i != this.getPostCount() + this.getInternalNodeCount(); ++i) {
            this.volts[i] = 0.0;
        }
        this.curcount = 0.0;
    }

    void draw(Graphics graphics) {
    }

    void setCurrent(int n, double d) {
        this.current = d;
    }

    double getCurrent() {
        return this.current;
    }

    void doStep() {
    }

    void delete() {
    }

    void startIteration() {
    }

    double getPostVoltage(int n) {
        return this.volts[n];
    }

    void setNodeVoltage(int n, double d) {
        this.volts[n] = d;
        this.calculateCurrent();
    }

    void calculateCurrent() {
    }

    void setPoints() {
        this.dx = this.x2 - this.x;
        this.dy = this.y2 - this.y;
        this.dn = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.dpx1 = (double)this.dy / this.dn;
        this.dpy1 = (double)(-this.dx) / this.dn;
        this.dsign = this.dy == 0 ? CircuitElm.sign(this.dx) : CircuitElm.sign(this.dy);
        this.point1 = new Point(this.x, this.y);
        this.point2 = new Point(this.x2, this.y2);
    }

    void calcLeads(int n) {
        if (this.dn < (double)n || n == 0) {
            this.lead1 = this.point1;
            this.lead2 = this.point2;
            return;
        }
        this.lead1 = this.interpPoint(this.point1, this.point2, (this.dn - (double)n) / (2.0 * this.dn));
        this.lead2 = this.interpPoint(this.point1, this.point2, (this.dn + (double)n) / (2.0 * this.dn));
    }

    Point interpPoint(Point point, Point point2, double d) {
        Point point3 = new Point();
        this.interpPoint(point, point2, point3, d);
        return point3;
    }

    void interpPoint(Point point, Point point2, Point point3, double d) {
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        point3.x = (int)Math.floor((double)point.x * (1.0 - d) + (double)point2.x * d + 0.48);
        point3.y = (int)Math.floor((double)point.y * (1.0 - d) + (double)point2.y * d + 0.48);
    }

    void interpPoint(Point point, Point point2, Point point3, double d, double d2) {
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        int n3 = point2.y - point.y;
        int n4 = point.x - point2.x;
        point3.x = (int)Math.floor((double)point.x * (1.0 - d) + (double)point2.x * d + (d2 /= Math.sqrt(n3 * n3 + n4 * n4)) * (double)n3 + 0.48);
        point3.y = (int)Math.floor((double)point.y * (1.0 - d) + (double)point2.y * d + d2 * (double)n4 + 0.48);
    }

    Point interpPoint(Point point, Point point2, double d, double d2) {
        Point point3 = new Point();
        this.interpPoint(point, point2, point3, d, d2);
        return point3;
    }

    void interpPoint2(Point point, Point point2, Point point3, Point point4, double d, double d2) {
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        int n3 = point2.y - point.y;
        int n4 = point.x - point2.x;
        point3.x = (int)Math.floor((double)point.x * (1.0 - d) + (double)point2.x * d + (d2 /= Math.sqrt(n3 * n3 + n4 * n4)) * (double)n3 + 0.48);
        point3.y = (int)Math.floor((double)point.y * (1.0 - d) + (double)point2.y * d + d2 * (double)n4 + 0.48);
        point4.x = (int)Math.floor((double)point.x * (1.0 - d) + (double)point2.x * d - d2 * (double)n3 + 0.48);
        point4.y = (int)Math.floor((double)point.y * (1.0 - d) + (double)point2.y * d - d2 * (double)n4 + 0.48);
    }

    void draw2Leads(Graphics graphics) {
        this.setVoltageColor(graphics, this.volts[0]);
        CircuitElm.drawThickLine(graphics, this.point1, this.lead1);
        this.setVoltageColor(graphics, this.volts[1]);
        CircuitElm.drawThickLine(graphics, this.lead2, this.point2);
    }

    Point[] newPointArray(int n) {
        Point[] pointArray = new Point[n];
        while (n > 0) {
            pointArray[--n] = new Point();
        }
        return pointArray;
    }

    void drawDots(Graphics graphics, Point point, Point point2, double d) {
        if (CircuitElm.sim.stoppedCheck.getState() || d == 0.0 || !CircuitElm.sim.dotsCheckItem.getState()) {
            return;
        }
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        double d2 = Math.sqrt(n * n + n2 * n2);
        graphics.setColor(Color.yellow);
        int n3 = 16;
        d %= (double)n3;
        if (d < 0.0) {
            d += (double)n3;
        }
        double d3 = 0.0;
        for (d3 = d; d3 < d2; d3 += (double)n3) {
            int n4 = (int)((double)point.x + d3 * (double)n / d2);
            int n5 = (int)((double)point.y + d3 * (double)n2 / d2);
            graphics.fillRect(n4 - 1, n5 - 1, 4, 4);
        }
    }

    Polygon calcArrow(Point point, Point point2, double d, double d2) {
        Polygon polygon = new Polygon();
        Point point3 = new Point();
        Point point4 = new Point();
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        double d3 = Math.sqrt(n * n + n2 * n2);
        polygon.addPoint(point2.x, point2.y);
        this.interpPoint2(point, point2, point3, point4, 1.0 - d / d3, d2);
        polygon.addPoint(point3.x, point3.y);
        polygon.addPoint(point4.x, point4.y);
        return polygon;
    }

    Polygon createPolygon(Point point, Point point2, Point point3) {
        Polygon polygon = new Polygon();
        polygon.addPoint(point.x, point.y);
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(point3.x, point3.y);
        return polygon;
    }

    Polygon createPolygon(Point point, Point point2, Point point3, Point point4) {
        Polygon polygon = new Polygon();
        polygon.addPoint(point.x, point.y);
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(point3.x, point3.y);
        polygon.addPoint(point4.x, point4.y);
        return polygon;
    }

    Polygon createPolygon(Point[] pointArray) {
        Polygon polygon = new Polygon();
        for (int i = 0; i != pointArray.length; ++i) {
            polygon.addPoint(pointArray[i].x, pointArray[i].y);
        }
        return polygon;
    }

    void drag(int n, int n2) {
        n = sim.snapGrid(n);
        n2 = sim.snapGrid(n2);
        if (this.noDiagonal) {
            if (Math.abs(this.x - n) < Math.abs(this.y - n2)) {
                n = this.x;
            } else {
                n2 = this.y;
            }
        }
        this.x2 = n;
        this.y2 = n2;
        this.setPoints();
    }

    void move(int n, int n2) {
        this.x += n;
        this.y += n2;
        this.x2 += n;
        this.y2 += n2;
        this.boundingBox.move(n, n2);
        this.setPoints();
    }

    boolean allowMove(int n, int n2) {
        int n3 = this.x + n;
        int n4 = this.y + n2;
        int n5 = this.x2 + n;
        int n6 = this.y2 + n2;
        for (int i = 0; i != CircuitElm.sim.elmList.size(); ++i) {
            CircuitElm circuitElm = sim.getElm(i);
            if (circuitElm.x == n3 && circuitElm.y == n4 && circuitElm.x2 == n5 && circuitElm.y2 == n6) {
                return false;
            }
            if (circuitElm.x != n5 || circuitElm.y != n6 || circuitElm.x2 != n3 || circuitElm.y2 != n4) continue;
            return false;
        }
        return true;
    }

    void movePoint(int n, int n2, int n3) {
        if (n == 0) {
            this.x += n2;
            this.y += n3;
        } else {
            this.x2 += n2;
            this.y2 += n3;
        }
        this.setPoints();
    }

    void drawPosts(Graphics graphics) {
        for (int i = 0; i != this.getPostCount(); ++i) {
            Point point = this.getPost(i);
            this.drawPost(graphics, point.x, point.y, this.nodes[i]);
        }
    }

    void stamp() {
    }

    int getVoltageSourceCount() {
        return 0;
    }

    int getInternalNodeCount() {
        return 0;
    }

    void setNode(int n, int n2) {
        this.nodes[n] = n2;
    }

    void setVoltageSource(int n, int n2) {
        this.voltSource = n2;
    }

    int getVoltageSource() {
        return this.voltSource;
    }

    double getVoltageDiff() {
        return this.volts[0] - this.volts[1];
    }

    boolean nonLinear() {
        return false;
    }

    int getPostCount() {
        return 2;
    }

    int getNode(int n) {
        return this.nodes[n];
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : (n == 1 ? this.point2 : null);
    }

    void drawPost(Graphics graphics, int n, int n2, int n3) {
        if (CircuitElm.sim.dragElm == null && !this.needsHighlight() && CircuitElm.sim.getCircuitNode((int)n3).links.size() == 2) {
            return;
        }
        if (CircuitElm.sim.mouseMode == 2 || CircuitElm.sim.mouseMode == 3) {
            return;
        }
        this.drawPost(graphics, n, n2);
    }

    void drawPost(Graphics graphics, int n, int n2) {
        graphics.setColor(whiteColor);
        graphics.fillOval(n - 3, n2 - 3, 7, 7);
    }

    void setBbox(int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        this.boundingBox.setBounds(n, n2, n3 - n + 1, n4 - n2 + 1);
    }

    void setBbox(Point point, Point point2, double d) {
        this.setBbox(point.x, point.y, point2.x, point2.y);
        int n = point2.y - point.y;
        int n2 = point.x - point2.x;
        int n3 = (int)(this.dpx1 * d);
        int n4 = (int)(this.dpy1 * d);
        this.adjustBbox(point.x + n3, point.y + n4, point.x - n3, point.y - n4);
    }

    void adjustBbox(int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        n = CircuitElm.min(this.boundingBox.x, n);
        n2 = CircuitElm.min(this.boundingBox.y, n2);
        n3 = CircuitElm.max(this.boundingBox.x + this.boundingBox.width - 1, n3);
        n4 = CircuitElm.max(this.boundingBox.y + this.boundingBox.height - 1, n4);
        this.boundingBox.setBounds(n, n2, n3 - n, n4 - n2);
    }

    void adjustBbox(Point point, Point point2) {
        this.adjustBbox(point.x, point.y, point2.x, point2.y);
    }

    boolean isCenteredText() {
        return false;
    }

    void drawCenteredText(Graphics graphics, String string, int n, int n2, boolean bl) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        if (bl) {
            n -= n3 / 2;
        }
        graphics.drawString(string, n, n2 + fontMetrics.getAscent() / 2);
        this.adjustBbox(n, n2 - fontMetrics.getAscent() / 2, n + n3, n2 + fontMetrics.getAscent() / 2 + fontMetrics.getDescent());
    }

    void drawValues(Graphics graphics, String string, double d) {
        int n;
        int n2;
        if (string == null) {
            return;
        }
        graphics.setFont(unitsFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        graphics.setColor(whiteColor);
        int n4 = fontMetrics.getAscent() / 2;
        if (this instanceof RailElm || this instanceof SweepElm) {
            n2 = this.x2;
            n = this.y2;
        } else {
            n2 = (this.x2 + this.x) / 2;
            n = (this.y2 + this.y) / 2;
        }
        int n5 = (int)(this.dpx1 * d);
        int n6 = (int)(this.dpy1 * d);
        if (n5 == 0) {
            graphics.drawString(string, n2 - n3 / 2, n - CircuitElm.abs(n6) - 2);
        } else {
            int n7 = n2 + CircuitElm.abs(n5) + 2;
            if (this instanceof VoltageElm || this.x < this.x2 && this.y > this.y2) {
                n7 = n2 - (n3 + CircuitElm.abs(n5) + 2);
            }
            graphics.drawString(string, n7, n + n6 + n4);
        }
    }

    void drawCoil(Graphics graphics, int n, Point point, Point point2, double d, double d2) {
        double d3 = CircuitElm.distance(point, point2);
        int n2 = 30;
        double d4 = 1.0 / (double)n2;
        ps1.setLocation(point);
        for (int i = 0; i != n2; ++i) {
            double d5 = (double)(i + 1) * 6.0 * d4 % 2.0 - 1.0;
            double d6 = Math.sqrt(1.0 - d5 * d5);
            if (d6 < 0.0) {
                d6 = -d6;
            }
            this.interpPoint(point, point2, ps2, (double)i * d4, d6 * (double)n);
            double d7 = d + (d2 - d) * (double)i / (double)n2;
            this.setVoltageColor(graphics, d7);
            CircuitElm.drawThickLine(graphics, ps1, ps2);
            ps1.setLocation(ps2);
        }
    }

    static void drawThickLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n + 1, n2, n3 + 1, n4);
        graphics.drawLine(n, n2 + 1, n3, n4 + 1);
        graphics.drawLine(n + 1, n2 + 1, n3 + 1, n4 + 1);
    }

    static void drawThickLine(Graphics graphics, Point point, Point point2) {
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.drawLine(point.x + 1, point.y, point2.x + 1, point2.y);
        graphics.drawLine(point.x, point.y + 1, point2.x, point2.y + 1);
        graphics.drawLine(point.x + 1, point.y + 1, point2.x + 1, point2.y + 1);
    }

    static void drawThickPolygon(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        int n2;
        for (n2 = 0; n2 != n - 1; ++n2) {
            CircuitElm.drawThickLine(graphics, nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1]);
        }
        CircuitElm.drawThickLine(graphics, nArray[n2], nArray2[n2], nArray[0], nArray2[0]);
    }

    static void drawThickPolygon(Graphics graphics, Polygon polygon) {
        CircuitElm.drawThickPolygon(graphics, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    static void drawThickCircle(Graphics graphics, int n, int n2, int n3) {
        double d = Math.PI / 180;
        double d2 = (double)n3 * 0.98;
        for (int i = 0; i != 360; i += 20) {
            double d3 = Math.cos((double)i * d) * d2 + (double)n;
            double d4 = Math.sin((double)i * d) * d2 + (double)n2;
            double d5 = Math.cos((double)(i + 20) * d) * d2 + (double)n;
            double d6 = Math.sin((double)(i + 20) * d) * d2 + (double)n2;
            CircuitElm.drawThickLine(graphics, (int)d3, (int)d4, (int)d5, (int)d6);
        }
    }

    static String getVoltageDText(double d) {
        return CircuitElm.getUnitText(Math.abs(d), "V");
    }

    static String getVoltageText(double d) {
        return CircuitElm.getUnitText(d, "V");
    }

    static String getUnitText(double d, String string) {
        double d2 = Math.abs(d);
        if (d2 < 1.0E-14) {
            return "0 " + string;
        }
        if (d2 < 1.0E-9) {
            return showFormat.format(d * 1.0E12) + " p" + string;
        }
        if (d2 < 1.0E-6) {
            return showFormat.format(d * 1.0E9) + " n" + string;
        }
        if (d2 < 0.001) {
            return showFormat.format(d * 1000000.0) + " " + CirSim.muString + string;
        }
        if (d2 < 1.0) {
            return showFormat.format(d * 1000.0) + " m" + string;
        }
        if (d2 < 1000.0) {
            return showFormat.format(d) + " " + string;
        }
        if (d2 < 1000000.0) {
            return showFormat.format(d * 0.001) + " k" + string;
        }
        if (d2 < 1.0E9) {
            return showFormat.format(d * 1.0E-6) + " M" + string;
        }
        return showFormat.format(d * 1.0E-9) + " G" + string;
    }

    static String getShortUnitText(double d, String string) {
        double d2 = Math.abs(d);
        if (d2 < 1.0E-13) {
            return null;
        }
        if (d2 < 1.0E-9) {
            return shortFormat.format(d * 1.0E12) + "p" + string;
        }
        if (d2 < 1.0E-6) {
            return shortFormat.format(d * 1.0E9) + "n" + string;
        }
        if (d2 < 0.001) {
            return shortFormat.format(d * 1000000.0) + CirSim.muString + string;
        }
        if (d2 < 1.0) {
            return shortFormat.format(d * 1000.0) + "m" + string;
        }
        if (d2 < 1000.0) {
            return shortFormat.format(d) + string;
        }
        if (d2 < 1000000.0) {
            return shortFormat.format(d * 0.001) + "k" + string;
        }
        if (d2 < 1.0E9) {
            return shortFormat.format(d * 1.0E-6) + "M" + string;
        }
        return shortFormat.format(d * 1.0E-9) + "G" + string;
    }

    static String getCurrentText(double d) {
        return CircuitElm.getUnitText(d, "A");
    }

    static String getCurrentDText(double d) {
        return CircuitElm.getUnitText(Math.abs(d), "A");
    }

    void updateDotCount() {
        this.curcount = this.updateDotCount(this.current, this.curcount);
    }

    double updateDotCount(double d, double d2) {
        if (CircuitElm.sim.stoppedCheck.getState()) {
            return d2;
        }
        double d3 = d * currentMult;
        return d2 + (d3 %= 8.0);
    }

    void doDots(Graphics graphics) {
        this.updateDotCount();
        if (CircuitElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.point2, this.curcount);
        }
    }

    void doAdjust() {
    }

    void setupAdjust() {
    }

    void getInfo(String[] stringArray) {
    }

    int getBasicInfo(String[] stringArray) {
        stringArray[1] = "I = " + CircuitElm.getCurrentDText(this.getCurrent());
        stringArray[2] = "Vd = " + CircuitElm.getVoltageDText(this.getVoltageDiff());
        return 3;
    }

    void setVoltageColor(Graphics graphics, double d) {
        if (this.needsHighlight()) {
            graphics.setColor(selectColor);
            return;
        }
        if (!CircuitElm.sim.voltsCheckItem.getState()) {
            if (!CircuitElm.sim.powerCheckItem.getState()) {
                graphics.setColor(whiteColor);
            }
            return;
        }
        int n = (int)((d + voltageRange) * (double)(colorScaleCount - 1) / (voltageRange * 2.0));
        if (n < 0) {
            n = 0;
        }
        if (n >= colorScaleCount) {
            n = colorScaleCount - 1;
        }
        graphics.setColor(colorScale[n]);
    }

    void setPowerColor(Graphics graphics, boolean bl) {
        if (!CircuitElm.sim.powerCheckItem.getState()) {
            return;
        }
        this.setPowerColor(graphics, this.getPower());
    }

    void setPowerColor(Graphics graphics, double d) {
        double d2;
        double d3 = d2 = (d *= powerMult) < 0.0 ? -d : d;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        int n = 128 + (int)(d2 * 127.0);
        int n2 = (int)(128.0 * (1.0 - d2));
        if (d > 0.0) {
            graphics.setColor(new Color(n, n2, n2));
        } else {
            graphics.setColor(new Color(n2, n, n2));
        }
    }

    void setConductanceColor(Graphics graphics, double d) {
        double d2;
        double d3 = d2 = (d *= powerMult) < 0.0 ? -d : d;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        int n = (int)(d2 * 255.0);
        graphics.setColor(new Color(n, n, n));
    }

    double getPower() {
        return this.getVoltageDiff() * this.current;
    }

    double getScopeValue(int n) {
        return n == 1 ? this.getPower() : this.getVoltageDiff();
    }

    String getScopeUnits(int n) {
        return n == 1 ? "W" : "V";
    }

    public EditInfo getEditInfo(int n) {
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
    }

    boolean getConnection(int n, int n2) {
        return true;
    }

    boolean hasGroundConnection(int n) {
        return false;
    }

    boolean isWire() {
        return false;
    }

    boolean canViewInScope() {
        return this.getPostCount() <= 2;
    }

    boolean comparePair(int n, int n2, int n3, int n4) {
        return n == n3 && n2 == n4 || n == n4 && n2 == n3;
    }

    boolean needsHighlight() {
        return CircuitElm.sim.mouseElm == this || this.selected;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean bl) {
        this.selected = bl;
    }

    void selectRect(Rectangle rectangle) {
        this.selected = rectangle.intersects(this.boundingBox);
    }

    static int abs(int n) {
        return n < 0 ? -n : n;
    }

    static int sign(int n) {
        return n < 0 ? -1 : (n == 0 ? 0 : 1);
    }

    static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    static double distance(Point point, Point point2) {
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    boolean needsShortcut() {
        return false;
    }
}

