/*
 * Decompiled with CFR 0.152.
 */
class Diode {
    int[] nodes;
    CirSim sim;
    public double leakage = 1.0E-14;
    double vt;
    double vdcoef;
    double fwdrop;
    double zvoltage;
    double zoffset;
    double lastvoltdiff;
    double vcrit;

    Diode(CirSim cirSim) {
        this.sim = cirSim;
        this.nodes = new int[2];
    }

    void setup(double d, double d2) {
        this.fwdrop = d;
        this.zvoltage = d2;
        this.vdcoef = Math.log(1.0 / this.leakage + 1.0) / this.fwdrop;
        this.vt = 1.0 / this.vdcoef;
        this.vcrit = this.vt * Math.log(this.vt / (Math.sqrt(2.0) * this.leakage));
        if (this.zvoltage == 0.0) {
            this.zoffset = 0.0;
        } else {
            double d3 = -0.005;
            this.zoffset = this.zvoltage - Math.log(-(1.0 + d3 / this.leakage)) / this.vdcoef;
        }
    }

    void reset() {
        this.lastvoltdiff = 0.0;
    }

    double limitStep(double d, double d2) {
        double d3 = d;
        if (d > this.vcrit && Math.abs(d - d2) > this.vt + this.vt) {
            if (d2 > 0.0) {
                double d4 = 1.0 + (d - d2) / this.vt;
                if (d4 > 0.0) {
                    d = d2 + this.vt * Math.log(d4);
                    double d5 = Math.log(1.0E-6 / this.leakage) * this.vt;
                    d = Math.max(d5, d);
                } else {
                    d = this.vcrit;
                }
            } else {
                d = this.vt * Math.log(d / this.vt);
            }
            this.sim.converged = false;
        } else if (d < 0.0 && this.zoffset != 0.0) {
            d = -d - this.zoffset;
            d2 = -d2 - this.zoffset;
            if (d > this.vcrit && Math.abs(d - d2) > this.vt + this.vt) {
                if (d2 > 0.0) {
                    double d6 = 1.0 + (d - d2) / this.vt;
                    if (d6 > 0.0) {
                        d = d2 + this.vt * Math.log(d6);
                        double d7 = Math.log(1.0E-6 / this.leakage) * this.vt;
                        d = Math.max(d7, d);
                    } else {
                        d = this.vcrit;
                    }
                } else {
                    d = this.vt * Math.log(d / this.vt);
                }
                this.sim.converged = false;
            }
            d = -(d + this.zoffset);
        }
        return d;
    }

    void stamp(int n, int n2) {
        this.nodes[0] = n;
        this.nodes[1] = n2;
        this.sim.stampNonLinear(this.nodes[0]);
        this.sim.stampNonLinear(this.nodes[1]);
    }

    void doStep(double d) {
        if (Math.abs(d - this.lastvoltdiff) > 0.01) {
            this.sim.converged = false;
        }
        this.lastvoltdiff = d = this.limitStep(d, this.lastvoltdiff);
        if (d >= 0.0 || this.zvoltage == 0.0) {
            double d2 = Math.exp(d * this.vdcoef);
            if (d < 0.0) {
                d2 = 1.0;
            }
            double d3 = this.vdcoef * this.leakage * d2;
            double d4 = (d2 - 1.0) * this.leakage - d3 * d;
            this.sim.stampConductance(this.nodes[0], this.nodes[1], d3);
            this.sim.stampCurrentSource(this.nodes[0], this.nodes[1], d4);
        } else {
            double d5 = this.leakage * this.vdcoef * (Math.exp(d * this.vdcoef) + Math.exp((-d - this.zoffset) * this.vdcoef));
            double d6 = this.leakage * (Math.exp(d * this.vdcoef) - Math.exp((-d - this.zoffset) * this.vdcoef) - 1.0) + d5 * -d;
            this.sim.stampConductance(this.nodes[0], this.nodes[1], d5);
            this.sim.stampCurrentSource(this.nodes[0], this.nodes[1], d6);
        }
    }

    double calculateCurrent(double d) {
        if (d >= 0.0 || this.zvoltage == 0.0) {
            return this.leakage * (Math.exp(d * this.vdcoef) - 1.0);
        }
        return this.leakage * (Math.exp(d * this.vdcoef) - Math.exp((-d - this.zoffset) * this.vdcoef) - 1.0);
    }
}

