/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class DiodeElm
extends CircuitElm {
    Diode diode = new Diode(sim);
    static final int FLAG_FWDROP = 1;
    final double defaultdrop = 0.805904783;
    double fwdrop = 0.805904783;
    double zvoltage = 0.0;
    final int hs = 8;
    Polygon poly;
    Point[] cathode;

    public DiodeElm(int n, int n2) {
        super(n, n2);
        this.setup();
    }

    public DiodeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        if ((n5 & 1) > 0) {
            try {
                this.fwdrop = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setup();
    }

    boolean nonLinear() {
        return true;
    }

    void setup() {
        this.diode.setup(this.fwdrop, this.zvoltage);
    }

    int getDumpType() {
        return 100;
    }

    String dump() {
        this.flags |= 1;
        return super.dump() + " " + this.fwdrop;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(16);
        this.cathode = this.newPointArray(2);
        Point[] pointArray = this.newPointArray(2);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, 8.0);
        this.interpPoint2(this.lead1, this.lead2, this.cathode[0], this.cathode[1], 1.0, 8.0);
        this.poly = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
    }

    void draw(Graphics graphics) {
        this.drawDiode(graphics);
        this.doDots(graphics);
        this.drawPosts(graphics);
    }

    void reset() {
        this.diode.reset();
        this.curcount = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
    }

    void drawDiode(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 8.0);
        double d = this.volts[0];
        double d2 = this.volts[1];
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        this.setVoltageColor(graphics, d);
        graphics.fillPolygon(this.poly);
        this.setVoltageColor(graphics, d2);
        DiodeElm.drawThickLine(graphics, this.cathode[0], this.cathode[1]);
    }

    void stamp() {
        this.diode.stamp(this.nodes[0], this.nodes[1]);
    }

    void doStep() {
        this.diode.doStep(this.volts[0] - this.volts[1]);
    }

    void calculateCurrent() {
        this.current = this.diode.calculateCurrent(this.volts[0] - this.volts[1]);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "diode";
        stringArray[1] = "I = " + DiodeElm.getCurrentText(this.getCurrent());
        stringArray[2] = "Vd = " + DiodeElm.getVoltageText(this.getVoltageDiff());
        stringArray[3] = "P = " + DiodeElm.getUnitText(this.getPower(), "W");
        stringArray[4] = "Vf = " + DiodeElm.getVoltageText(this.fwdrop);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Fwd Voltage @ 1A", this.fwdrop, 10.0, 1000.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        this.fwdrop = editInfo.value;
        this.setup();
    }

    boolean needsShortcut() {
        return this.getClass() == DiodeElm.class;
    }
}

