/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

abstract class GateElm
extends CircuitElm {
    final int FLAG_SMALL = 1;
    int inputCount = 2;
    boolean lastOutput;
    int gsize;
    int gwidth;
    int gwidth2;
    int gheight;
    int hs2;
    Point[] inPosts;
    Point[] inGates;
    int ww;
    Polygon gatePoly;
    Point pcircle;
    Point[] linePoints;

    public GateElm(int n, int n2) {
        super(n, n2);
        this.noDiagonal = true;
        this.inputCount = 2;
        this.setSize(GateElm.sim.smallGridCheckItem.getState() ? 1 : 2);
    }

    public GateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.inputCount = new Integer(stringTokenizer.nextToken());
        this.lastOutput = new Double(stringTokenizer.nextToken()) > 2.5;
        this.noDiagonal = true;
        this.setSize((n5 & 1) != 0 ? 1 : 2);
    }

    boolean isInverting() {
        return false;
    }

    void setSize(int n) {
        this.gsize = n;
        this.gwidth = 7 * n;
        this.gwidth2 = 14 * n;
        this.gheight = 8 * n;
        this.flags = n == 1 ? 1 : 0;
    }

    String dump() {
        return super.dump() + " " + this.inputCount + " " + this.volts[this.inputCount];
    }

    void setPoints() {
        super.setPoints();
        if (this.dn > 150.0 && this == GateElm.sim.dragElm) {
            this.setSize(2);
        }
        int n = this.gheight;
        this.ww = this.gwidth2;
        if ((double)this.ww > this.dn / 2.0) {
            this.ww = (int)(this.dn / 2.0);
        }
        if (this.isInverting() && (double)(this.ww + 8) > this.dn / 2.0) {
            this.ww = (int)(this.dn / 2.0 - 8.0);
        }
        this.calcLeads(this.ww * 2);
        this.inPosts = new Point[this.inputCount];
        this.inGates = new Point[this.inputCount];
        this.allocNodes();
        int n2 = -this.inputCount / 2;
        int n3 = 0;
        while (n3 != this.inputCount) {
            if (n2 == 0 && (this.inputCount & 1) == 0) {
                ++n2;
            }
            this.inPosts[n3] = this.interpPoint(this.point1, this.point2, 0.0, (double)(n * n2));
            this.inGates[n3] = this.interpPoint(this.lead1, this.lead2, 0.0, (double)(n * n2));
            this.volts[n3] = this.lastOutput ^ this.isInverting() ? 5.0 : 0.0;
            ++n3;
            ++n2;
        }
        this.hs2 = this.gwidth * (this.inputCount / 2 + 1);
        this.setBbox(this.point1, this.point2, this.hs2);
    }

    void draw(Graphics graphics) {
        int n;
        for (n = 0; n != this.inputCount; ++n) {
            this.setVoltageColor(graphics, this.volts[n]);
            GateElm.drawThickLine(graphics, this.inPosts[n], this.inGates[n]);
        }
        this.setVoltageColor(graphics, this.volts[this.inputCount]);
        GateElm.drawThickLine(graphics, this.lead2, this.point2);
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        GateElm.drawThickPolygon(graphics, this.gatePoly);
        if (this.linePoints != null) {
            for (n = 0; n != this.linePoints.length - 1; ++n) {
                GateElm.drawThickLine(graphics, this.linePoints[n], this.linePoints[n + 1]);
            }
        }
        if (this.isInverting()) {
            GateElm.drawThickCircle(graphics, this.pcircle.x, this.pcircle.y, 3);
        }
        this.curcount = this.updateDotCount(this.current, this.curcount);
        this.drawDots(graphics, this.lead2, this.point2, this.curcount);
        this.drawPosts(graphics);
    }

    int getPostCount() {
        return this.inputCount + 1;
    }

    Point getPost(int n) {
        if (n == this.inputCount) {
            return this.point2;
        }
        return this.inPosts[n];
    }

    int getVoltageSourceCount() {
        return 1;
    }

    abstract String getGateName();

    void getInfo(String[] stringArray) {
        stringArray[0] = this.getGateName();
        stringArray[1] = "Vout = " + GateElm.getVoltageText(this.volts[this.inputCount]);
        stringArray[2] = "Iout = " + GateElm.getCurrentText(this.getCurrent());
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[this.inputCount], this.voltSource);
    }

    boolean getInput(int n) {
        return this.volts[n] > 2.5;
    }

    abstract boolean calcFunction();

    void doStep() {
        boolean bl = this.calcFunction();
        if (this.isInverting()) {
            bl = !bl;
        }
        this.lastOutput = bl;
        double d = bl ? 5.0 : 0.0;
        sim.updateVoltageSource(0, this.nodes[this.inputCount], this.voltSource, d);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("# of Inputs", this.inputCount, 1.0, 8.0).setDimensionless();
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        this.inputCount = (int)editInfo.value;
        this.setPoints();
    }

    boolean getConnection(int n, int n2) {
        return false;
    }

    boolean hasGroundConnection(int n) {
        return n == this.inputCount;
    }
}

