/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class RelayElm
extends CircuitElm {
    double inductance;
    Inductor ind;
    double r_on;
    double r_off;
    double onCurrent;
    Point[] coilPosts;
    Point[] coilLeads;
    Point[][] swposts;
    Point[][] swpoles;
    Point[] ptSwitch;
    Point[] lines;
    double coilCurrent;
    double[] switchCurrent;
    double coilCurCount;
    double[] switchCurCount;
    double d_position;
    double coilR;
    int i_position;
    int poleCount;
    int openhs;
    final int nSwitch0 = 0;
    final int nSwitch1 = 1;
    final int nSwitch2 = 2;
    int nCoil1;
    int nCoil2;
    int nCoil3;
    final int FLAG_SWAP_COIL = 1;
    double a1;
    double a2;
    double a3;
    double a4;

    public RelayElm(int n, int n2) {
        super(n, n2);
        this.ind = new Inductor(sim);
        this.inductance = 0.2;
        this.ind.setup(this.inductance, 0.0, 2);
        this.noDiagonal = true;
        this.onCurrent = 0.02;
        this.r_on = 0.05;
        this.r_off = 1000000.0;
        this.coilR = 20.0;
        this.coilCurCount = 0.0;
        this.coilCurrent = 0.0;
        this.poleCount = 1;
        this.setupPoles();
    }

    public RelayElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.poleCount = new Integer(stringTokenizer.nextToken());
        this.inductance = new Double(stringTokenizer.nextToken());
        this.coilCurrent = new Double(stringTokenizer.nextToken());
        this.r_on = new Double(stringTokenizer.nextToken());
        this.r_off = new Double(stringTokenizer.nextToken());
        this.onCurrent = new Double(stringTokenizer.nextToken());
        this.coilR = new Double(stringTokenizer.nextToken());
        this.noDiagonal = true;
        this.ind = new Inductor(sim);
        this.ind.setup(this.inductance, this.coilCurrent, 2);
        this.setupPoles();
    }

    void setupPoles() {
        this.nCoil1 = 3 * this.poleCount;
        this.nCoil2 = this.nCoil1 + 1;
        this.nCoil3 = this.nCoil1 + 2;
        if (this.switchCurrent == null || this.switchCurrent.length != this.poleCount) {
            this.switchCurrent = new double[this.poleCount];
            this.switchCurCount = new double[this.poleCount];
        }
    }

    int getDumpType() {
        return 178;
    }

    String dump() {
        return super.dump() + " " + this.poleCount + " " + this.inductance + " " + this.coilCurrent + " " + this.r_on + " " + this.r_off + " " + this.onCurrent + " " + this.coilR;
    }

    void draw(Graphics graphics) {
        int n;
        for (n = 0; n != 2; ++n) {
            this.setVoltageColor(graphics, this.volts[this.nCoil1 + n]);
            RelayElm.drawThickLine(graphics, this.coilLeads[n], this.coilPosts[n]);
        }
        int n2 = (this.flags & 1) != 0 ? 1 : 0;
        this.drawCoil(graphics, this.dsign * 6, this.coilLeads[n2], this.coilLeads[1 - n2], this.volts[this.nCoil1 + n2], this.volts[this.nCoil2 - n2]);
        graphics.setColor(Color.darkGray);
        for (n = 0; n != this.poleCount; ++n) {
            if (n == 0) {
                this.interpPoint(this.point1, this.point2, this.lines[n * 2], 0.5, this.openhs * 2 + 5 * this.dsign - n * this.openhs * 3);
            } else {
                this.interpPoint(this.point1, this.point2, this.lines[n * 2], 0.5, (int)((double)this.openhs * ((double)(-n * 3 + 3) - 0.5 + this.d_position)) + 5 * this.dsign);
            }
            this.interpPoint(this.point1, this.point2, this.lines[n * 2 + 1], 0.5, (int)((double)this.openhs * ((double)(-n * 3) - 0.5 + this.d_position)) - 5 * this.dsign);
            graphics.drawLine(this.lines[n * 2].x, this.lines[n * 2].y, this.lines[n * 2 + 1].x, this.lines[n * 2 + 1].y);
        }
        for (int i = 0; i != this.poleCount; ++i) {
            int n3 = i * 3;
            for (n = 0; n != 3; ++n) {
                this.setVoltageColor(graphics, this.volts[0 + n3 + n]);
                RelayElm.drawThickLine(graphics, this.swposts[i][n], this.swpoles[i][n]);
            }
            this.interpPoint(this.swpoles[i][1], this.swpoles[i][2], this.ptSwitch[i], this.d_position);
            graphics.setColor(Color.lightGray);
            RelayElm.drawThickLine(graphics, this.swpoles[i][0], this.ptSwitch[i]);
            this.switchCurCount[i] = this.updateDotCount(this.switchCurrent[i], this.switchCurCount[i]);
            this.drawDots(graphics, this.swposts[i][0], this.swpoles[i][0], this.switchCurCount[i]);
            if (this.i_position == 2) continue;
            this.drawDots(graphics, this.swpoles[i][this.i_position + 1], this.swposts[i][this.i_position + 1], this.switchCurCount[i]);
        }
        this.coilCurCount = this.updateDotCount(this.coilCurrent, this.coilCurCount);
        this.drawDots(graphics, this.coilPosts[0], this.coilLeads[0], this.coilCurCount);
        this.drawDots(graphics, this.coilLeads[0], this.coilLeads[1], this.coilCurCount);
        this.drawDots(graphics, this.coilLeads[1], this.coilPosts[1], this.coilCurCount);
        this.drawPosts(graphics);
        this.setBbox(this.coilPosts[0], this.coilLeads[1], 0.0);
        this.adjustBbox(this.swpoles[this.poleCount - 1][0], this.swposts[this.poleCount - 1][1]);
    }

    void setPoints() {
        super.setPoints();
        this.setupPoles();
        this.allocNodes();
        this.openhs = -this.dsign * 16;
        this.calcLeads(32);
        this.swposts = new Point[this.poleCount][3];
        this.swpoles = new Point[this.poleCount][3];
        for (int i = 0; i != this.poleCount; ++i) {
            for (int j = 0; j != 3; ++j) {
                this.swposts[i][j] = new Point();
                this.swpoles[i][j] = new Point();
            }
            this.interpPoint(this.lead1, this.lead2, this.swpoles[i][0], 0.0, -this.openhs * 3 * i);
            this.interpPoint(this.lead1, this.lead2, this.swpoles[i][1], 1.0, -this.openhs * 3 * i - this.openhs);
            this.interpPoint(this.lead1, this.lead2, this.swpoles[i][2], 1.0, -this.openhs * 3 * i + this.openhs);
            this.interpPoint(this.point1, this.point2, this.swposts[i][0], 0.0, -this.openhs * 3 * i);
            this.interpPoint(this.point1, this.point2, this.swposts[i][1], 1.0, -this.openhs * 3 * i - this.openhs);
            this.interpPoint(this.point1, this.point2, this.swposts[i][2], 1.0, -this.openhs * 3 * i + this.openhs);
        }
        this.coilPosts = this.newPointArray(2);
        this.coilLeads = this.newPointArray(2);
        this.ptSwitch = this.newPointArray(this.poleCount);
        boolean bl = (this.flags & 1) != 0;
        this.interpPoint(this.point1, this.point2, this.coilPosts[0], (double)bl, this.openhs * 2);
        this.interpPoint(this.point1, this.point2, this.coilPosts[1], (double)bl, this.openhs * 3);
        this.interpPoint(this.point1, this.point2, this.coilLeads[0], 0.5, this.openhs * 2);
        this.interpPoint(this.point1, this.point2, this.coilLeads[1], 0.5, this.openhs * 3);
        this.lines = this.newPointArray(this.poleCount * 2);
    }

    Point getPost(int n) {
        if (n < 3 * this.poleCount) {
            return this.swposts[n / 3][n % 3];
        }
        return this.coilPosts[n - 3 * this.poleCount];
    }

    int getPostCount() {
        return 2 + this.poleCount * 3;
    }

    int getInternalNodeCount() {
        return 1;
    }

    void reset() {
        super.reset();
        this.ind.reset();
        this.coilCurCount = 0.0;
        this.coilCurrent = 0.0;
        for (int i = 0; i != this.poleCount; ++i) {
            this.switchCurCount[i] = 0.0;
            this.switchCurrent[i] = 0.0;
        }
    }

    void stamp() {
        this.ind.stamp(this.nodes[this.nCoil1], this.nodes[this.nCoil3]);
        sim.stampResistor(this.nodes[this.nCoil3], this.nodes[this.nCoil2], this.coilR);
        for (int i = 0; i != this.poleCount * 3; ++i) {
            sim.stampNonLinear(this.nodes[0 + i]);
        }
    }

    void startIteration() {
        this.ind.startIteration(this.volts[this.nCoil1] - this.volts[this.nCoil3]);
        double d = 1.3;
        double d2 = Math.sqrt(d + 1.0);
        double d3 = this.coilCurrent * d2 / this.onCurrent;
        this.d_position = Math.abs(d3 * d3) - 1.3;
        if (this.d_position < 0.0) {
            this.d_position = 0.0;
        }
        if (this.d_position > 1.0) {
            this.d_position = 1.0;
        }
        this.i_position = this.d_position < 0.1 ? 0 : (this.d_position > 0.9 ? 1 : 2);
    }

    boolean nonLinear() {
        return true;
    }

    void doStep() {
        double d = this.volts[this.nCoil1] - this.volts[this.nCoil3];
        this.ind.doStep(d);
        for (int i = 0; i != this.poleCount * 3; i += 3) {
            sim.stampResistor(this.nodes[0 + i], this.nodes[1 + i], this.i_position == 0 ? this.r_on : this.r_off);
            sim.stampResistor(this.nodes[0 + i], this.nodes[2 + i], this.i_position == 1 ? this.r_on : this.r_off);
        }
    }

    void calculateCurrent() {
        double d = this.volts[this.nCoil1] - this.volts[this.nCoil3];
        this.coilCurrent = this.ind.calculateCurrent(d);
        for (int i = 0; i != this.poleCount; ++i) {
            this.switchCurrent[i] = this.i_position == 2 ? 0.0 : (this.volts[0 + i * 3] - this.volts[1 + i * 3 + this.i_position]) / this.r_on;
        }
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = this.i_position == 0 ? "relay (off)" : (this.i_position == 1 ? "relay (on)" : "relay");
        int n = 1;
        for (int i = 0; i != this.poleCount; ++i) {
            stringArray[n++] = "I" + (i + 1) + " = " + RelayElm.getCurrentDText(this.switchCurrent[i]);
        }
        stringArray[n++] = "coil I = " + RelayElm.getCurrentDText(this.coilCurrent);
        stringArray[n++] = "coil Vd = " + RelayElm.getVoltageDText(this.volts[this.nCoil1] - this.volts[this.nCoil2]);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Inductance (H)", this.inductance, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("On Resistance (ohms)", this.r_on, 0.0, 0.0);
        }
        if (n == 2) {
            return new EditInfo("Off Resistance (ohms)", this.r_off, 0.0, 0.0);
        }
        if (n == 3) {
            return new EditInfo("On Current (A)", this.onCurrent, 0.0, 0.0);
        }
        if (n == 4) {
            return new EditInfo("Number of Poles", this.poleCount, 1.0, 4.0).setDimensionless();
        }
        if (n == 5) {
            return new EditInfo("Coil Resistance (ohms)", this.coilR, 0.0, 0.0);
        }
        if (n == 6) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Swap Coil Direction", (this.flags & 1) != 0);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0 && editInfo.value > 0.0) {
            this.inductance = editInfo.value;
            this.ind.setup(this.inductance, this.coilCurrent, 2);
        }
        if (n == 1 && editInfo.value > 0.0) {
            this.r_on = editInfo.value;
        }
        if (n == 2 && editInfo.value > 0.0) {
            this.r_off = editInfo.value;
        }
        if (n == 3 && editInfo.value > 0.0) {
            this.onCurrent = editInfo.value;
        }
        if (n == 4 && editInfo.value >= 1.0) {
            this.poleCount = (int)editInfo.value;
            this.setPoints();
        }
        if (n == 5 && editInfo.value > 0.0) {
            this.coilR = editInfo.value;
        }
        if (n == 6) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
            this.setPoints();
        }
    }

    boolean getConnection(int n, int n2) {
        return n / 3 == n2 / 3;
    }
}

