/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class ResistorElm
extends CircuitElm {
    double resistance;
    Point ps3;
    Point ps4;

    public ResistorElm(int n, int n2) {
        super(n, n2);
        this.resistance = 100.0;
    }

    public ResistorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.resistance = new Double(stringTokenizer.nextToken());
    }

    int getDumpType() {
        return 114;
    }

    String dump() {
        return super.dump() + " " + this.resistance;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
        this.ps3 = new Point();
        this.ps4 = new Point();
    }

    void draw(Graphics graphics) {
        int n = 16;
        int n2 = 0;
        int n3 = ResistorElm.sim.euroResistorCheckItem.getState() ? 6 : 8;
        double d = this.volts[0];
        double d2 = this.volts[1];
        this.setBbox(this.point1, this.point2, n3);
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        double d3 = 1.0 / (double)n;
        if (!ResistorElm.sim.euroResistorCheckItem.getState()) {
            for (int i = 0; i != n; ++i) {
                int n4 = 0;
                switch (i & 3) {
                    case 0: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n4 = -1;
                        break;
                    }
                    default: {
                        n4 = 0;
                    }
                }
                double d4 = d + (d2 - d) * (double)i / (double)n;
                this.setVoltageColor(graphics, d4);
                this.interpPoint(this.lead1, this.lead2, ps1, (double)i * d3, n3 * n2);
                this.interpPoint(this.lead1, this.lead2, ps2, (double)(i + 1) * d3, n3 * n4);
                ResistorElm.drawThickLine(graphics, ps1, ps2);
                n2 = n4;
            }
        } else {
            this.setVoltageColor(graphics, d);
            this.interpPoint2(this.lead1, this.lead2, ps1, ps2, 0.0, n3);
            ResistorElm.drawThickLine(graphics, ps1, ps2);
            for (int i = 0; i != n; ++i) {
                double d5 = d + (d2 - d) * (double)i / (double)n;
                this.setVoltageColor(graphics, d5);
                this.interpPoint2(this.lead1, this.lead2, ps1, ps2, (double)i * d3, n3);
                this.interpPoint2(this.lead1, this.lead2, this.ps3, this.ps4, (double)(i + 1) * d3, n3);
                ResistorElm.drawThickLine(graphics, ps1, this.ps3);
                ResistorElm.drawThickLine(graphics, ps2, this.ps4);
            }
            this.interpPoint2(this.lead1, this.lead2, ps1, ps2, 1.0, n3);
            ResistorElm.drawThickLine(graphics, ps1, ps2);
        }
        if (ResistorElm.sim.showValuesCheckItem.getState()) {
            String string = ResistorElm.getShortUnitText(this.resistance, "");
            this.drawValues(graphics, string, n3);
        }
        this.doDots(graphics);
        this.drawPosts(graphics);
    }

    void calculateCurrent() {
        this.current = (this.volts[0] - this.volts[1]) / this.resistance;
    }

    void stamp() {
        sim.stampResistor(this.nodes[0], this.nodes[1], this.resistance);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "resistor";
        this.getBasicInfo(stringArray);
        stringArray[3] = "R = " + ResistorElm.getUnitText(this.resistance, CirSim.ohmString);
        stringArray[4] = "P = " + ResistorElm.getUnitText(this.getPower(), "W");
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Resistance (ohms)", this.resistance, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (editInfo.value > 0.0) {
            this.resistance = editInfo.value;
        }
    }

    boolean needsShortcut() {
        return true;
    }
}

