/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class SparkGapElm
extends CircuitElm {
    double resistance;
    double onresistance;
    double offresistance;
    double breakdown;
    double holdcurrent;
    boolean state;
    Polygon arrow1;
    Polygon arrow2;

    public SparkGapElm(int n, int n2) {
        super(n, n2);
        this.offresistance = 1.0E9;
        this.onresistance = 1000.0;
        this.breakdown = 1000.0;
        this.holdcurrent = 0.001;
        this.state = false;
    }

    public SparkGapElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.onresistance = new Double(stringTokenizer.nextToken());
        this.offresistance = new Double(stringTokenizer.nextToken());
        this.breakdown = new Double(stringTokenizer.nextToken());
        this.holdcurrent = new Double(stringTokenizer.nextToken());
    }

    boolean nonLinear() {
        return true;
    }

    int getDumpType() {
        return 187;
    }

    String dump() {
        return super.dump() + " " + this.onresistance + " " + this.offresistance + " " + this.breakdown + " " + this.holdcurrent;
    }

    void setPoints() {
        super.setPoints();
        int n = 16;
        int n2 = 8;
        this.calcLeads(n + n2);
        Point point = this.interpPoint(this.point1, this.point2, (this.dn - (double)n2) / (2.0 * this.dn));
        this.arrow1 = this.calcArrow(this.point1, point, n2, n2);
        point = this.interpPoint(this.point1, this.point2, (this.dn + (double)n2) / (2.0 * this.dn));
        this.arrow2 = this.calcArrow(this.point2, point, n2, n2);
    }

    void draw(Graphics graphics) {
        double d = this.volts[0];
        double d2 = this.volts[1];
        this.setBbox(this.point1, this.point2, 8.0);
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        this.setVoltageColor(graphics, this.volts[0]);
        graphics.fillPolygon(this.arrow1);
        this.setVoltageColor(graphics, this.volts[1]);
        graphics.fillPolygon(this.arrow2);
        if (this.state) {
            this.doDots(graphics);
        }
        this.drawPosts(graphics);
    }

    void calculateCurrent() {
        double d = this.volts[0] - this.volts[1];
        this.current = d / this.resistance;
    }

    void reset() {
        super.reset();
        this.state = false;
    }

    void startIteration() {
        double d;
        if (Math.abs(this.current) < this.holdcurrent) {
            this.state = false;
        }
        if (Math.abs(d = this.volts[0] - this.volts[1]) > this.breakdown) {
            this.state = true;
        }
    }

    void doStep() {
        this.resistance = this.state ? this.onresistance : this.offresistance;
        sim.stampResistor(this.nodes[0], this.nodes[1], this.resistance);
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "spark gap";
        this.getBasicInfo(stringArray);
        stringArray[3] = this.state ? "on" : "off";
        stringArray[4] = "Ron = " + SparkGapElm.getUnitText(this.onresistance, CirSim.ohmString);
        stringArray[5] = "Roff = " + SparkGapElm.getUnitText(this.offresistance, CirSim.ohmString);
        stringArray[6] = "Vbreakdown = " + SparkGapElm.getUnitText(this.breakdown, "V");
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("On resistance (ohms)", this.onresistance, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("Off resistance (ohms)", this.offresistance, 0.0, 0.0);
        }
        if (n == 2) {
            return new EditInfo("Breakdown voltage", this.breakdown, 0.0, 0.0);
        }
        if (n == 3) {
            return new EditInfo("Holding current (A)", this.holdcurrent, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (editInfo.value > 0.0 && n == 0) {
            this.onresistance = editInfo.value;
        }
        if (editInfo.value > 0.0 && n == 1) {
            this.offresistance = editInfo.value;
        }
        if (editInfo.value > 0.0 && n == 2) {
            this.breakdown = editInfo.value;
        }
        if (editInfo.value > 0.0 && n == 3) {
            this.holdcurrent = editInfo.value;
        }
    }

    boolean needsShortcut() {
        return false;
    }
}

