/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class ADCElm
extends ChipElm {
    public ADCElm(int n, int n2) {
        super(n, n2);
    }

    public ADCElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "ADC";
    }

    boolean needsBits() {
        return true;
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = this.bits > 2 ? this.bits : 2;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        for (int i = 0; i != this.bits; ++i) {
            this.pins[i] = new ChipElm.Pin(this, this.bits - 1 - i, 3, "D" + i);
            this.pins[i].output = true;
        }
        this.pins[this.bits] = new ChipElm.Pin(this, 0, 2, "In");
        this.pins[this.bits + 1] = new ChipElm.Pin(this, this.sizeY - 1, 2, "V+");
        this.allocNodes();
    }

    void execute() {
        int n = (1 << this.bits) - 1;
        double d = (double)n * this.volts[this.bits] / this.volts[this.bits + 1];
        int n2 = (int)d;
        n2 = ADCElm.min(n, ADCElm.max(0, n2));
        for (int i = 0; i != this.bits; ++i) {
            this.pins[i].value = (n2 & 1 << i) != 0;
        }
    }

    int getVoltageSourceCount() {
        return this.bits;
    }

    int getPostCount() {
        return this.bits + 2;
    }

    int getDumpType() {
        return 167;
    }
}

