/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class CapacitorElm
extends CircuitElm {
    double capacitance;
    double compResistance;
    double voltdiff;
    Point[] plate1;
    Point[] plate2;
    public static final int FLAG_BACK_EULER = 2;
    double curSourceValue;

    public CapacitorElm(int n, int n2) {
        super(n, n2);
        this.capacitance = 1.0E-5;
    }

    public CapacitorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.capacitance = new Double(stringTokenizer.nextToken());
        this.voltdiff = new Double(stringTokenizer.nextToken());
    }

    boolean isTrapezoidal() {
        return (this.flags & 2) == 0;
    }

    void setNodeVoltage(int n, double d) {
        super.setNodeVoltage(n, d);
        this.voltdiff = this.volts[0] - this.volts[1];
    }

    void reset() {
        this.curcount = 0.0;
        this.current = 0.0;
        this.voltdiff = 0.001;
    }

    int getDumpType() {
        return 99;
    }

    String dump() {
        return super.dump() + " " + this.capacitance + " " + this.voltdiff;
    }

    void setPoints() {
        super.setPoints();
        double d = (this.dn / 2.0 - 4.0) / this.dn;
        this.lead1 = this.interpPoint(this.point1, this.point2, d);
        this.lead2 = this.interpPoint(this.point1, this.point2, 1.0 - d);
        this.plate1 = this.newPointArray(2);
        this.plate2 = this.newPointArray(2);
        this.interpPoint2(this.point1, this.point2, this.plate1[0], this.plate1[1], d, 12.0);
        this.interpPoint2(this.point1, this.point2, this.plate2[0], this.plate2[1], 1.0 - d, 12.0);
    }

    void draw(Graphics graphics) {
        int n = 12;
        this.setBbox(this.point1, this.point2, n);
        this.setVoltageColor(graphics, this.volts[0]);
        CapacitorElm.drawThickLine(graphics, this.point1, this.lead1);
        this.setPowerColor(graphics, false);
        CapacitorElm.drawThickLine(graphics, this.plate1[0], this.plate1[1]);
        if (CapacitorElm.sim.powerCheckItem.getState()) {
            graphics.setColor(Color.gray);
        }
        this.setVoltageColor(graphics, this.volts[1]);
        CapacitorElm.drawThickLine(graphics, this.point2, this.lead2);
        this.setPowerColor(graphics, false);
        CapacitorElm.drawThickLine(graphics, this.plate2[0], this.plate2[1]);
        this.updateDotCount();
        if (CapacitorElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
            this.drawDots(graphics, this.point2, this.lead2, -this.curcount);
        }
        this.drawPosts(graphics);
        if (CapacitorElm.sim.showValuesCheckItem.getState()) {
            String string = CapacitorElm.getShortUnitText(this.capacitance, "F");
            this.drawValues(graphics, string, n);
        }
    }

    void stamp() {
        this.compResistance = this.isTrapezoidal() ? CapacitorElm.sim.timeStep / (2.0 * this.capacitance) : CapacitorElm.sim.timeStep / this.capacitance;
        sim.stampResistor(this.nodes[0], this.nodes[1], this.compResistance);
        sim.stampRightSide(this.nodes[0]);
        sim.stampRightSide(this.nodes[1]);
    }

    void startIteration() {
        this.curSourceValue = this.isTrapezoidal() ? -this.voltdiff / this.compResistance - this.current : -this.voltdiff / this.compResistance;
    }

    void calculateCurrent() {
        double d = this.volts[0] - this.volts[1];
        if (this.compResistance > 0.0) {
            this.current = d / this.compResistance + this.curSourceValue;
        }
    }

    void doStep() {
        sim.stampCurrentSource(this.nodes[0], this.nodes[1], this.curSourceValue);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "capacitor";
        this.getBasicInfo(stringArray);
        stringArray[3] = "C = " + CapacitorElm.getUnitText(this.capacitance, "F");
        stringArray[4] = "P = " + CapacitorElm.getUnitText(this.getPower(), "W");
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Capacitance (F)", this.capacitance, 0.0, 0.0);
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Trapezoidal Approximation", this.isTrapezoidal());
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0 && editInfo.value > 0.0) {
            this.capacitance = editInfo.value;
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        }
    }

    boolean needsShortcut() {
        return true;
    }
}

