/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

class EditDialog
extends Dialog
implements AdjustmentListener,
ActionListener,
ItemListener {
    Editable elm;
    CirSim cframe;
    Button applyButton;
    Button okButton;
    EditInfo[] einfos;
    int einfocount;
    final int barmax = 1000;
    NumberFormat noCommaFormat;

    EditDialog(Editable editable, CirSim cirSim) {
        super(cirSim, "Edit Component", false);
        Object object;
        this.cframe = cirSim;
        this.elm = editable;
        this.setLayout(new EditDialogLayout());
        this.einfos = new EditInfo[10];
        this.noCommaFormat = DecimalFormat.getInstance();
        this.noCommaFormat.setMaximumFractionDigits(10);
        this.noCommaFormat.setGroupingUsed(false);
        int n = 0;
        while (true) {
            this.einfos[n] = this.elm.getEditInfo(n);
            if (this.einfos[n] == null) break;
            object = this.einfos[n];
            this.add(new Label(((EditInfo)object).name));
            if (((EditInfo)object).choice != null) {
                this.add(((EditInfo)object).choice);
                ((EditInfo)object).choice.addItemListener(this);
            } else if (((EditInfo)object).checkbox != null) {
                this.add(((EditInfo)object).checkbox);
                ((EditInfo)object).checkbox.addItemListener(this);
            } else {
                ((EditInfo)object).textf = new TextField(this.unitString((EditInfo)object), 10);
                this.add(((EditInfo)object).textf);
                if (((EditInfo)object).text != null) {
                    ((EditInfo)object).textf.setText(((EditInfo)object).text);
                }
                ((EditInfo)object).textf.addActionListener(this);
                if (((EditInfo)object).text == null) {
                    ((EditInfo)object).bar = new Scrollbar(0, 50, 10, 0, 1002);
                    this.add(((EditInfo)object).bar);
                    this.setBar((EditInfo)object);
                    ((EditInfo)object).bar.addAdjustmentListener(this);
                }
            }
            ++n;
        }
        this.einfocount = n;
        this.applyButton = new Button("Apply");
        this.add(this.applyButton);
        this.applyButton.addActionListener(this);
        this.okButton = new Button("OK");
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        object = CirSim.main.getLocationOnScreen();
        Dimension dimension = this.getSize();
        this.setLocation(((Point)object).x + (this.cframe.winSize.width - dimension.width) / 2, ((Point)object).y + (this.cframe.winSize.height - dimension.height) / 2);
    }

    String unitString(EditInfo editInfo) {
        double d = editInfo.value;
        double d2 = Math.abs(d);
        if (editInfo.dimensionless) {
            return this.noCommaFormat.format(d);
        }
        if (d == 0.0) {
            return "0";
        }
        if (d2 < 1.0E-9) {
            return this.noCommaFormat.format(d * 1.0E12) + "p";
        }
        if (d2 < 1.0E-6) {
            return this.noCommaFormat.format(d * 1.0E9) + "n";
        }
        if (d2 < 0.001) {
            return this.noCommaFormat.format(d * 1000000.0) + "u";
        }
        if (d2 < 1.0 && !editInfo.forceLargeM) {
            return this.noCommaFormat.format(d * 1000.0) + "m";
        }
        if (d2 < 1000.0) {
            return this.noCommaFormat.format(d);
        }
        if (d2 < 1000000.0) {
            return this.noCommaFormat.format(d * 0.001) + "k";
        }
        if (d2 < 1.0E9) {
            return this.noCommaFormat.format(d * 1.0E-6) + "M";
        }
        return this.noCommaFormat.format(d * 1.0E-9) + "G";
    }

    double parseUnits(EditInfo editInfo) throws ParseException {
        String string = editInfo.textf.getText();
        string = string.trim();
        int n = string.length();
        char c = string.charAt(n - 1);
        double d = 1.0;
        switch (c) {
            case 'P': 
            case 'p': {
                d = 1.0E-12;
                break;
            }
            case 'N': 
            case 'n': {
                d = 1.0E-9;
                break;
            }
            case 'U': 
            case 'u': {
                d = 1.0E-6;
                break;
            }
            case 'm': {
                d = editInfo.forceLargeM ? 1000000.0 : 0.001;
                break;
            }
            case 'K': 
            case 'k': {
                d = 1000.0;
                break;
            }
            case 'M': {
                d = 1000000.0;
                break;
            }
            case 'G': 
            case 'g': {
                d = 1.0E9;
            }
        }
        if (d != 1.0) {
            string = string.substring(0, n - 1).trim();
        }
        return this.noCommaFormat.parse(string).doubleValue() * d;
    }

    void apply() {
        for (int i = 0; i != this.einfocount; ++i) {
            EditInfo editInfo = this.einfos[i];
            if (editInfo.textf == null) continue;
            if (editInfo.text == null) {
                try {
                    double d;
                    editInfo.value = d = this.parseUnits(editInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.elm.setEditValue(i, editInfo);
            if (editInfo.text != null) continue;
            this.setBar(editInfo);
        }
        this.cframe.needAnalyze();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        for (int i = 0; i != this.einfocount; ++i) {
            EditInfo editInfo = this.einfos[i];
            if (object != editInfo.textf) continue;
            if (editInfo.text == null) {
                try {
                    double d;
                    editInfo.value = d = this.parseUnits(editInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.elm.setEditValue(i, editInfo);
            if (editInfo.text == null) {
                this.setBar(editInfo);
            }
            this.cframe.needAnalyze();
        }
        if (actionEvent.getSource() == this.okButton) {
            this.apply();
            CirSim.main.requestFocus();
            this.setVisible(false);
            CirSim.editDialog = null;
        }
        if (actionEvent.getSource() == this.applyButton) {
            this.apply();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        for (int i = 0; i != this.einfocount; ++i) {
            EditInfo editInfo = this.einfos[i];
            if (editInfo.bar != object) continue;
            double d = (double)editInfo.bar.getValue() / 1000.0;
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            editInfo.value = (editInfo.maxval - editInfo.minval) * d + editInfo.minval;
            editInfo.value = (double)Math.round(editInfo.value / editInfo.minval) * editInfo.minval;
            this.elm.setEditValue(i, editInfo);
            editInfo.textf.setText(this.unitString(editInfo));
            this.cframe.needAnalyze();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl = false;
        for (int i = 0; i != this.einfocount; ++i) {
            EditInfo editInfo = this.einfos[i];
            if (editInfo.choice != itemSelectable && editInfo.checkbox != itemSelectable) continue;
            this.elm.setEditValue(i, editInfo);
            if (editInfo.newDialog) {
                bl = true;
            }
            this.cframe.needAnalyze();
        }
        if (bl) {
            this.setVisible(false);
            CirSim.editDialog = new EditDialog(this.elm, this.cframe);
            CirSim.editDialog.show();
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            CirSim.main.requestFocus();
            this.setVisible(false);
            CirSim.editDialog = null;
            return true;
        }
        return super.handleEvent(event);
    }

    void setBar(EditInfo editInfo) {
        int n = (int)(1000.0 * (editInfo.value - editInfo.minval) / (editInfo.maxval - editInfo.minval));
        editInfo.bar.setValue(n);
    }
}

