/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Graphics;
import java.util.StringTokenizer;

class InductorElm
extends CircuitElm {
    Inductor ind = new Inductor(sim);
    double inductance;

    public InductorElm(int n, int n2) {
        super(n, n2);
        this.inductance = 1.0;
        this.ind.setup(this.inductance, this.current, this.flags);
    }

    public InductorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.inductance = new Double(stringTokenizer.nextToken());
        this.current = new Double(stringTokenizer.nextToken());
        this.ind.setup(this.inductance, this.current, this.flags);
    }

    int getDumpType() {
        return 108;
    }

    String dump() {
        return super.dump() + " " + this.inductance + " " + this.current;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
    }

    void draw(Graphics graphics) {
        double d = this.volts[0];
        double d2 = this.volts[1];
        int n = 8;
        this.setBbox(this.point1, this.point2, n);
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, false);
        this.drawCoil(graphics, 8, this.lead1, this.lead2, d, d2);
        if (InductorElm.sim.showValuesCheckItem.getState()) {
            String string = InductorElm.getShortUnitText(this.inductance, "H");
            this.drawValues(graphics, string, n);
        }
        this.doDots(graphics);
        this.drawPosts(graphics);
    }

    void reset() {
        this.curcount = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.current = 0.0;
        this.ind.reset();
    }

    void stamp() {
        this.ind.stamp(this.nodes[0], this.nodes[1]);
    }

    void startIteration() {
        this.ind.startIteration(this.volts[0] - this.volts[1]);
    }

    boolean nonLinear() {
        return this.ind.nonLinear();
    }

    void calculateCurrent() {
        double d = this.volts[0] - this.volts[1];
        this.current = this.ind.calculateCurrent(d);
    }

    void doStep() {
        double d = this.volts[0] - this.volts[1];
        this.ind.doStep(d);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "inductor";
        this.getBasicInfo(stringArray);
        stringArray[3] = "L = " + InductorElm.getUnitText(this.inductance, "H");
        stringArray[4] = "P = " + InductorElm.getUnitText(this.getPower(), "W");
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Inductance (H)", this.inductance, 0.0, 0.0);
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Trapezoidal Approximation", this.ind.isTrapezoidal());
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.inductance = editInfo.value;
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        }
        this.ind.setup(this.inductance, this.current, this.flags);
    }
}

