/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class JKFlipFlopElm
extends ChipElm {
    public JKFlipFlopElm(int n, int n2) {
        super(n, n2);
    }

    public JKFlipFlopElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.pins[4].value = !this.pins[3].value;
    }

    String getChipName() {
        return "JK flip-flop";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 3;
        this.pins = new ChipElm.Pin[5];
        this.pins[0] = new ChipElm.Pin(0, 2, "J");
        this.pins[1] = new ChipElm.Pin(1, 2, "");
        this.pins[1].clock = true;
        this.pins[1].bubble = true;
        this.pins[2] = new ChipElm.Pin(2, 2, "K");
        this.pins[3] = new ChipElm.Pin(0, 3, "Q");
        this.pins[3].state = true;
        this.pins[3].output = true;
        this.pins[4] = new ChipElm.Pin(2, 3, "Q");
        this.pins[4].output = true;
        this.pins[4].lineOver = true;
    }

    int getPostCount() {
        return 5;
    }

    int getVoltageSourceCount() {
        return 2;
    }

    void execute() {
        if (!this.pins[1].value && this.lastClock) {
            boolean bl = this.pins[3].value;
            if (this.pins[0].value) {
                bl = this.pins[2].value ? !bl : true;
            } else if (this.pins[2].value) {
                bl = false;
            }
            this.pins[3].value = bl;
            this.pins[4].value = !bl;
        }
        this.lastClock = this.pins[1].value;
    }

    int getDumpType() {
        return 156;
    }
}

