/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Graphics;
import java.util.StringTokenizer;

class LogicInputElm
extends SwitchElm {
    final int FLAG_TERNARY = 1;
    final int FLAG_NUMERIC = 2;
    double hiV;
    double loV;

    public LogicInputElm(int n, int n2) {
        super(n, n2, false);
        this.hiV = 5.0;
        this.loV = 0.0;
    }

    public LogicInputElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        try {
            this.hiV = new Double(stringTokenizer.nextToken());
            this.loV = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            this.hiV = 5.0;
            this.loV = 0.0;
        }
        if (this.isTernary()) {
            this.posCount = 3;
        }
    }

    boolean isTernary() {
        return (this.flags & 1) != 0;
    }

    boolean isNumeric() {
        return (this.flags & 3) != 0;
    }

    int getDumpType() {
        return 76;
    }

    String dump() {
        return super.dump() + " " + this.hiV + " " + this.loV;
    }

    int getPostCount() {
        return 1;
    }

    void setPoints() {
        super.setPoints();
        this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 12.0 / this.dn);
    }

    void draw(Graphics graphics) {
        String string;
        Font font = new Font("SansSerif", 1, 20);
        graphics.setFont(font);
        graphics.setColor(this.needsHighlight() ? selectColor : whiteColor);
        String string2 = string = this.position == 0 ? "L" : "H";
        if (this.isNumeric()) {
            string = "" + this.position;
        }
        this.setBbox(this.point1, this.lead1, 0.0);
        this.drawCenteredText(graphics, string, this.x2, this.y2, true);
        this.setVoltageColor(graphics, this.volts[0]);
        LogicInputElm.drawThickLine(graphics, this.point1, this.lead1);
        this.updateDotCount();
        this.drawDots(graphics, this.point1, this.lead1, this.curcount);
        this.drawPosts(graphics);
    }

    void setCurrent(int n, double d) {
        this.current = -d;
    }

    void stamp() {
        double d;
        double d2 = d = this.position == 0 ? this.loV : this.hiV;
        if (this.isTernary()) {
            d = (double)this.position * 2.5;
        }
        sim.stampVoltageSource(0, this.nodes[0], this.voltSource, d);
    }

    int getVoltageSourceCount() {
        return 1;
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "logic input";
        String string = stringArray[1] = this.position == 0 ? "low" : "high";
        if (this.isNumeric()) {
            stringArray[1] = "" + this.position;
        }
        stringArray[1] = stringArray[1] + " (" + LogicInputElm.getVoltageText(this.volts[0]) + ")";
        stringArray[2] = "I = " + LogicInputElm.getCurrentText(this.getCurrent());
    }

    boolean hasGroundConnection(int n) {
        return true;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, 0.0, 0.0);
            editInfo.checkbox = new Checkbox("Momentary Switch", this.momentary);
            return editInfo;
        }
        if (n == 1) {
            return new EditInfo("High Voltage", this.hiV, 10.0, -10.0);
        }
        if (n == 2) {
            return new EditInfo("Low Voltage", this.loV, 10.0, -10.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.momentary = editInfo.checkbox.getState();
        }
        if (n == 1) {
            this.hiV = editInfo.value;
        }
        if (n == 2) {
            this.loV = editInfo.value;
        }
    }
}

