/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class SwitchElm
extends CircuitElm {
    boolean momentary;
    int position;
    int posCount;
    Point ps;
    Point ps2;

    public SwitchElm(int n, int n2) {
        super(n, n2);
        this.momentary = false;
        this.position = 0;
        this.posCount = 2;
    }

    SwitchElm(int n, int n2, boolean bl) {
        super(n, n2);
        this.position = bl ? 1 : 0;
        this.momentary = bl;
        this.posCount = 2;
    }

    public SwitchElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        String string = stringTokenizer.nextToken();
        this.position = string.compareTo("true") == 0 ? (this instanceof LogicInputElm ? 0 : 1) : (string.compareTo("false") == 0 ? (this instanceof LogicInputElm ? 1 : 0) : new Integer(string));
        this.momentary = new Boolean(stringTokenizer.nextToken());
        this.posCount = 2;
    }

    int getDumpType() {
        return 115;
    }

    String dump() {
        return super.dump() + " " + this.position + " " + this.momentary;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
        this.ps = new Point();
        this.ps2 = new Point();
    }

    void draw(Graphics graphics) {
        int n = 16;
        int n2 = this.position == 1 ? 0 : 2;
        int n3 = this.position == 1 ? n : 2;
        this.setBbox(this.point1, this.point2, n);
        this.draw2Leads(graphics);
        if (this.position == 0) {
            this.doDots(graphics);
        }
        if (!this.needsHighlight()) {
            graphics.setColor(whiteColor);
        }
        this.interpPoint(this.lead1, this.lead2, this.ps, 0.0, n2);
        this.interpPoint(this.lead1, this.lead2, this.ps2, 1.0, n3);
        SwitchElm.drawThickLine(graphics, this.ps, this.ps2);
        this.drawPosts(graphics);
    }

    void calculateCurrent() {
        if (this.position == 1) {
            this.current = 0.0;
        }
    }

    void stamp() {
        if (this.position == 0) {
            sim.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, 0.0);
        }
    }

    int getVoltageSourceCount() {
        return this.position == 1 ? 0 : 1;
    }

    void mouseUp() {
        if (this.momentary) {
            this.toggle();
        }
    }

    void toggle() {
        ++this.position;
        if (this.position >= this.posCount) {
            this.position = 0;
        }
    }

    void getInfo(String[] stringArray) {
        String string = stringArray[0] = this.momentary ? "push switch (SPST)" : "switch (SPST)";
        if (this.position == 1) {
            stringArray[1] = "open";
            stringArray[2] = "Vd = " + SwitchElm.getVoltageDText(this.getVoltageDiff());
        } else {
            stringArray[1] = "closed";
            stringArray[2] = "V = " + SwitchElm.getVoltageText(this.volts[0]);
            stringArray[3] = "I = " + SwitchElm.getCurrentDText(this.getCurrent());
        }
    }

    boolean getConnection(int n, int n2) {
        return this.position == 0;
    }

    boolean isWire() {
        return true;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Momentary Switch", this.momentary);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.momentary = editInfo.checkbox.getState();
        }
    }
}

