clear all
data = loadcarcinoma('carcinoma.txt');

%convert cell data into matrix data
dataMat=[]
for i=1:36
    dataMat=[dataMat;data(i).x];
end

% Normalize data
% mean=0 and std=1
meangenes = mean(dataMat);
stdgenes = std(dataMat);
dataMatNorm = [];
for i=1:36
    dataMatNorm = [dataMatNorm;(data(i).x - meangenes)./stdgenes];
end

% plot features 1 to 6
mx=6
mn=1
for i=mn:mx
    for j=mn:mx
        subplot(mx-mn+1,mx-mn+1,(i-1)*(mx-mn+1)+j)
        for k=1:length(data)
            if (data(k).isTumor)
                plot(dataMatNorm(k,i), dataMatNorm(k,j), '.r')
            else
                plot(dataMatNorm(k,i), dataMatNorm(k,j), '.b')
            end
            hold on
        end
        hold off
    end
end

