function data=loadcarcinoma(filename)
  fid=fopen(filename,'r');
  %load first line, headers
  lin=fgetl(fid);
  tabixs=[findstr(lin,sprintf('\t')),length(lin)+1]
  data=[];
  
  %read data labels
  %first is gene/sample
  for f=1:length(tabixs)-1
    label=lin(tabixs(f)+1:tabixs(f+1)-1);
    data(f).label=label;
    data(f).isTumor=length(findstr('T',label))>0;
    data(f).x=[];    
  end
  
  %read attributes
  while ~feof(fid)
    lin=fgetl(fid);   
    if ischar(lin)
      tabixs=[findstr(lin,sprintf('\t')),length(lin)+1];
      %first one is the attribute label
      attribIx=length(data(1).x)+1;
      for f=1:length(tabixs)-1
        num=lin(tabixs(f)+1:tabixs(f+1)-1);
        data(f).x(attribIx)=str2num(num);
      end
    end
  end    
  fclose(fid);
end