import java.util.*;

public class Environ {

    class Assoc {
	String id;
        IValue v;
	
	public Assoc(String s, IValue vi)
	{
		id = s;
		v = vi;
        }
	
	String getId() 
	{
	    return id;
        }

	IValue getValue() 
	{
	    return v;
        }
    }

    public class UndeclaredIdentifier extends Exception {
	String id;

	public UndeclaredIdentifier(String s)
	{
		id = s;
        }
    }

    public class IdentifierDeclaredTwice extends Exception {
	String id;

	public IdentifierDeclaredTwice(String s)
	{
		id = s;
        }
    }



Environ upper;
Vector<Assoc> alist;

        private Environ(Environ up)
        {
		upper = up;
        }

        public Environ()
        {
		upper = null;
		alist = new Vector<Assoc>(5,1);
        }

	private Environ getUpper()
	{ 
	    return upper;
	}

	public Environ beginScope()
	{ 
	    upper = new Environ(upper);
	    return upper;
	}

	public Environ endScope()
	{ 
	    upper = upper.getUpper();
	    return upper;
	}

        IValue find(String id) throws UndeclaredIdentifier
	{ 
	    Iterator<Assoc> al = alist.iterator();
            while (al.hasNext()) 
		{   
		    Assoc a = al.next();
		    if (a.getId().equals(id))
			return a.getValue();
		}
	    if (upper != null) 
		return upper.find(id) ;
		else throw new UndeclaredIdentifier(id);
	}

        void assoc(String id, IValue v) throws IdentifierDeclaredTwice
	{ 
	    Iterator<Assoc> al = alist.iterator();
            while (al.hasNext()) {   
		    Assoc a = al.next();
		    if (a.getId().equals(id))
			throw new IdentifierDeclaredTwice(id);
		}
	    alist.addElement(new Assoc(id,v));
	}

}

