import java.util.Scanner;

import network.*;

/**
 * 
 */

/**
 * @author 53298
 *
 */
public class Main {
	/**
	 * constants for command reader
	 */
	private static final String CHECK_PERSON = "CONSULTAPESSOA";
	private static final String REGISTER = "REGISTA";
	private static final String CHECK_FRIENDSHIP = "CONSULTAAMIZADE";
	private static final String CREATE_FRIENDSHIP = "AMIGOS";
	private static final String CHECK_FRIENDS = "CONSULTAAMIGOS";
	private static final String NEW_STATE = "NOVOESTADO";
	private static final String CHECK_STATE = "CONSULTAESTADO";
	private static final String CHECK_ACCOUNTS = "PESSOAS";
	private static final String POST_PUBLIC = "POSTARPUBLICO";
	private static final String POST_ON_FRIEND = "POSTAR";
	private static final String POST_VIEW_FRIEND = "MURAL";
	private static final String QUIT = "SAIR";

	/**
	 * constants for messages
	 */
	private static final String MSG_PERSON_IS_REGISTERED = "Pessoa registada.";
	private static final String MSG_PERSON_IS_NOT_REGISTERED = "Sem registo.";
	private static final String MSG_PERSON_REGISTERED = "Pessoa registada com sucesso.";
	private static final String MSG_PERSON_EMPTY = "Rede Social vazia.";
	private static final String MSG_PERSON_NOT_EMPTY = "Lista de pessoas registadas:";
	private static final String MSG_FRIENDSHIP_EXISTS = "Amizade existente.";
	private static final String MSG_FRIENDSHIP_NOT_EXISTS = "Amizade inexistente.";
	private static final String MSG_FRIENDSHIP_CREATED = "Amizade criada.";
	private static final String MSG_FRIENDSHIP_INVALID = "Amizade invalida.";
	private static final String MSG_FRIENDS_LIST = "Lista de amigos:";
	private static final String MSG_FRIENDS_NONE = "Nao tem amigos registados.";
	private static final String MSG_STATE_MODIFIED = "Estado alterado.";
	private static final String MSG_POST_REGISTERED = "Post registado.";
	private static final String MSG_POST_LIST = "Mural de ";
	private static final String MSG_QUIT = "Adeus.";

	public static void main(String[] args) {
		Network net = new NetworkClass();
		Scanner in = new Scanner(System.in);
		String option = "";
		while (!option.equals(QUIT)) {
			option = in.next().toUpperCase();
			switch (option) {
			case CHECK_PERSON:
				checkPerson(in, net);
				System.out.println("");
				break;
			case REGISTER:
				register(in, net);
				System.out.println("");
				break;
			case CHECK_FRIENDSHIP:
				checkFriendship(in, net);
				System.out.println("");
				break;
			case CREATE_FRIENDSHIP:
				createFriendship(in, net);
				System.out.println("");
				break;
			case CHECK_FRIENDS:
				checkFriends(in, net);
				System.out.println("");
				break;
			case NEW_STATE:
				newState(in, net);
				System.out.println("");
				break;
			case CHECK_STATE:
				checkState(in, net);
				System.out.println("");
				break;
			case CHECK_ACCOUNTS:
				checkAccounts(in, net);
				System.out.println("");
				break;
			case POST_PUBLIC:
				postPublic(in, net);
				System.out.println("");
				break;
			case POST_ON_FRIEND:
				postPrivate(in, net);
				System.out.println("");
				break;
			case POST_VIEW_FRIEND:
				postViewFriend(in, net);
				System.out.println("");
				break;
			default:
				break;
			}
		}
		System.out.println(MSG_QUIT);
		System.out.println("");
		in.close();
	}

	private static void checkPerson(Scanner in, Network net) {
		String name = in.next();
		name += in.nextLine();
		if (net.checkPerson(name))
			System.out.println(MSG_PERSON_IS_REGISTERED);
		else
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
	}

	private static void register(Scanner in, Network net) {
		String name = in.next();
		name += in.nextLine();
		String mail = in.next();
		String state = in.next();
		state += in.nextLine();
		if (!net.register(name, mail, state))
			System.out.println(MSG_PERSON_IS_REGISTERED);
		else
			System.out.println(MSG_PERSON_REGISTERED);
	}

	private static void checkFriendship(Scanner in, Network net) {
		String name1 = in.next();
		name1 += in.nextLine();
		String name2 = in.next();
		name2 += in.nextLine();
		if (net.checkFriendship(name1, name2))
			System.out.println(MSG_FRIENDSHIP_EXISTS);
		else
			System.out.println(MSG_FRIENDSHIP_NOT_EXISTS);
	}

	private static void createFriendship(Scanner in, Network net) {
		String name1 = in.next();
		name1 += in.nextLine();
		String name2 = in.next();
		name2 += in.nextLine();
		int result = net.createFriendship(name1, name2);
		if (result == 1)
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
		else if (result == 2)
			System.out.println(MSG_FRIENDSHIP_EXISTS);
		else if (result == 3)
			System.out.println(MSG_FRIENDSHIP_INVALID);
		else
			System.out.println(MSG_FRIENDSHIP_CREATED);
	}

	private static void checkFriends(Scanner in, Network net) {
		String name = in.next();
		name += in.nextLine();
		if (net.checkFriends(name) == 1)
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
		else if (net.checkFriends(name) == 2)
			System.out.println(MSG_FRIENDS_NONE);
		else {
			System.out.println(MSG_FRIENDS_LIST);
			int index = net.searchByName(name);
			net.initializeFriendsIterator(index);
			while (net.hasNextFriend(index)) {
				Persons friend = net.nextFriend(index);
				System.out.println(friend.getName() + "; " + friend.getMail());
			}
		}
	}

	private static void newState(Scanner in, Network net) {
		String name = in.next();
		name += in.nextLine();
		String state = in.next();
		state += in.nextLine();
		if (net.newState(name, state))
			System.out.println(MSG_STATE_MODIFIED);
		else
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
	}

	private static void checkState(Scanner in, Network net) {
		String name = in.next();
		name += in.nextLine();
		if (net.checkState(name).equals(""))
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
		else
			System.out.println(net.checkState(name));
	}

	private static void checkAccounts(Scanner in, Network net) {
		in.nextLine();
		if (net.getCounter() == 0)
			System.out.println(MSG_PERSON_EMPTY);
		else {
			System.out.println(MSG_PERSON_NOT_EMPTY);
			Persons persons[] = net.checkAccounts();
			int current = 0;
			while (current < net.getCounter()) {
				System.out.println(persons[current].getName() + "; " + persons[current].getMail());
				current++;
			}
		}
	}
	
	private static void postPublic(Scanner in, Network net) {
		String author = in.next();
		author += in.nextLine();
		String message = in.next();
		message += in.nextLine();
		if (net.post(author, message, "", false) == 1)
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
		else
			System.out.println(MSG_POST_REGISTERED);
	}
	
	private static void postPrivate(Scanner in, Network net) {
		String author = in.next();
		author += in.nextLine();
		String message = in.next();
		message += in.nextLine();
		String friend = in.next();
		friend += in.nextLine();
		int error = net.post(author, message, friend, true);
		if (error == 1)
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
		else if (error == 2)
			System.out.println(MSG_FRIENDSHIP_NOT_EXISTS);
		else
			System.out.println(MSG_POST_REGISTERED);
	}
	
	private static void postViewFriend(Scanner in, Network net) {
		String friend = in.next();
		friend += in.nextLine();
		String owner = in.next();
		owner += in.nextLine();
		if (!net.checkPerson(friend) || !net.checkPerson(owner))
			System.out.println(MSG_PERSON_IS_NOT_REGISTERED);
		else if (!net.checkFriendship(friend, owner))
			System.out.println(MSG_FRIENDSHIP_NOT_EXISTS);
		else {
			System.out.println(MSG_POST_LIST + owner + ":");
			net.initialisePostsIterator(owner);
			Posts post = null;
			while (net.hasNextPost(owner)) {
				post = net.nextPost(owner);
				System.out.println("POST " + post.getAuthor() + ": " + post.getTimeLine());
			}
			/*Posts[] posts = net.postViewFriend(owner);
			System.out.println(MSG_POST_LIST + owner + ":");
			for (int pos = 0; posts[pos] != null; pos++) {
				System.out.println("POST " + posts[pos].getAuthor() + ": " + posts[pos].getTimeLine());
			}*/
		}
	}
}