package network;
/**
 * 
 */

/**
 * @author 53298
 *
 */
public interface Network {
	/**
	 * constants
	 */
	static final int CAPACITY_PERSONS = 500;
	static final int CAPACITY_POSTS = 50;

	/**
	 * checks if a person is registered
	 * 
	 * @param name
	 * @return true/false
	 */
	boolean checkPerson(String name);

	/**
	 * registers a person
	 * 
	 * @param name
	 * @param mail
	 * @param state
	 * @return true/false
	 */
	boolean register(String name, String mail, String state);

	/**
	 * checks friendship between two persons
	 * 
	 * @param name1
	 * @param name2
	 * @return true/false
	 */
	boolean checkFriendship(String name1, String name2);

	/**
	 * creates a new friendship
	 * 
	 * @param name1
	 * @param name2
	 * @return 0: success, 1: person1/person2 doesn't exists, 2: friendship already
	 *         exists, 3: one person friendship
	 */
	int createFriendship(String name1, String name2);

	/**
	 * lists all friends of a person
	 * 
	 * @param name
	 * @return 0: success, 1: no person with the given name
	 */
	int checkFriends(String name);

	/**
	 * modifies the person state
	 * 
	 * @param name
	 * @param state
	 * @return true/false
	 */
	boolean newState(String name, String state);

	/**
	 * gives a person state
	 * 
	 * @param name
	 * @return state
	 */
	String checkState(String name);

	/**
	 * lists all accounts
	 * 
	 * @return Persons iterator
	 */
	Persons[] checkAccounts();

	/**
	 * get number of persons
	 * 
	 * @return counter
	 */
	int getCounter();

	/**
	 * post a message
	 * 
	 * @param author
	 * @param message
	 * @param friend
	 * @param isPrivate
	 * @return 0: success, 1: no person, 2: no friendship
	 */
	int post(String author, String message, String friend, boolean isPrivate);

	/**
	 * get index by name
	 * 
	 * @param name
	 * @return index
	 */
	int searchByName(String name);

	/**
	 * initializes friends iterator
	 * 
	 * @param index
	 */
	void initializeFriendsIterator(int index);

	/**
	 * checks if there are other friends in the array
	 * 
	 * @param index
	 * 
	 * @return true/false
	 */
	boolean hasNextFriend(int index);

	/**
	 * gets current friend
	 * 
	 * @param index
	 * 
	 * @return current friend
	 */
	Persons nextFriend(int index);

	/**
	 * initializes friends iterator
	 * 
	 * @param owner
	 */
	void initialisePostsIterator(String owner);
	
	/**
	 * checks if there are other posts in the array
	 * 
	 * @param owner
	 * 
	 * @return true/false
	 */
	boolean hasNextPost(String owner);
	
	/**
	 * gets current post
	 * 
	 * @param owner
	 * 
	 * @return current post
	 */
	Posts nextPost(String owner);
}