/**
 * 
 */
package network;

/**
 * @author ALC
 *
 */
public class NetworkClass implements Network {

	Persons persons[];
	Posts posts[];

	/**
	 * variables
	 */
	private int counterPersons;

	public NetworkClass() {
		persons = new PersonsClass[CAPACITY_PERSONS];
		counterPersons = 0;
	}

	@Override
	public boolean checkPerson(String name) {
		boolean result = false;
		for (int pos = 0; pos < counterPersons && !result; pos++) {
			if (persons[pos].getName().equals(name))
				result = true;
		}
		return result;
	}

	@Override
	public boolean register(String name, String mail, String state) {
		boolean result = true;
		if (checkPerson(name))
			result = false;
		else
			persons[counterPersons++] = new PersonsClass(name, mail, state);
		return result;
	}

	@Override
	public boolean checkFriendship(String name1, String name2) {
		int pos1 = searchByName(name1);
		int pos2 = searchByName(name2);
		boolean hasFriendship = false;
		if (pos1 != -1 && pos2 != -1) {
			Persons person2 = null;
			persons[pos1].initializeFriendsIterator();
			while (persons[pos1].hasNextFriend() && !hasFriendship) {
				person2 = persons[pos1].nextFriend();
				if (person2.getName().equals(name2))
					hasFriendship = true;
			}
		}
		return hasFriendship;
	}

	@Override
	public int createFriendship(String name1, String name2) {
		int pos1 = searchByName(name1);
		int pos2 = searchByName(name2);
		int result = 0;
		if (pos1 == -1 || pos2 == -1)
			result = 1;
		else if (checkFriendship(name1, name2))
			result = 2;
		else if (name1.equals(name2))
			result = 3;
		else {
			persons[pos1].addFriend(name2, persons[pos2].getMail());
			persons[pos2].addFriend(name1, persons[pos1].getMail());
		}
		return result;
	}

	@Override
	public int checkFriends(String name) {
		int result = 0;
		if (persons[searchByName(name)].getFriendsCounter() == 0)
			result = 2;
		else if (searchByName(name) == -1)
			result = 1;
		return result;
	}

	@Override
	public boolean newState(String name, String state) {
		boolean result = false;
		if (checkPerson(name)) {
			persons[searchByName(name)].changeState(state);
			result = true;
		}
		return result;
	}

	@Override
	public String checkState(String name) {
		String result = "";
		if (checkPerson(name))
			result = persons[searchByName(name)].getState();
		return result;
	}

	@Override
	public Persons[] checkAccounts() {
		return persons;
	}

	@Override
	public int getCounter() {
		return counterPersons;
	}

	@Override
	public int post(String author, String message, String friend, boolean isPrivate) {
		int result = 0;
		if (isPrivate) {
			if (!checkPerson(author) || !checkPerson(friend))
				result = 1;
			else if (!checkFriendship(author, friend))
				result = 2;
			else {
				persons[searchByName(friend)].post(author, message, friend);
			}
		} else {
			if (!checkPerson(author))
				result = 1;
			else {
				persons[searchByName(author)].post(author, message, author);
				/*for (int i = 0; i < counterPersons; i++) {
					persons[i].post(author, message, "public");
				}*/
			}
		}
		return result;
	}

	@Override
	public int searchByName(String name) {
		int finalpos = -1;
		int pos = 0;
		while (finalpos == -1 && pos < getCounter()) {
			if (persons[pos].getName().equals(name))
				finalpos = pos;
			pos++;
		}
		return finalpos;
	}

	@Override
	public void initializeFriendsIterator(int index) {
		persons[index].initializeFriendsIterator();
	}

	@Override
	public boolean hasNextFriend(int index) {
		return persons[index].hasNextFriend();
	}

	@Override
	public Persons nextFriend(int index) {
		return persons[index].nextFriend();
	}

	@Override
	public void initialisePostsIterator(String owner) {
		persons[searchByName(owner)].initializePostsIterator();
	}

	@Override
	public boolean hasNextPost(String owner) {
		return persons[searchByName(owner)].hasNextPost();
	}

	@Override
	public Posts nextPost(String owner) {
		return persons[searchByName(owner)].nextPost();
	}
}
