/**
 * 
 */
package network;

/**
 * @author 53298
 *
 */
public interface Persons {
	/**
	 * constants
	 */
	static final int CAPACITY_FRIENDS = 50;
	static final int CAPACITY_POSTS = 50;

	/**
	 * adds a friend to a person
	 * 
	 * @param name
	 * @param mail
	 */
	void addFriend(String name, String mail);

	/**
	 * gets person name
	 * 
	 * @return person name
	 */
	String getName();

	/**
	 * gets person mail
	 * 
	 * @return person mail
	 */
	String getMail();

	/**
	 * gets person state
	 * 
	 * @return person state
	 */
	String getState();

	/**
	 * changes person state
	 * 
	 * @param state
	 */
	void changeState(String state);

	/**
	 * posts on a friend time line
	 * 
	 * @param author
	 * @param message
	 * @param friend
	 */
	void post(String author, String message, String friend);

	/**
	 * gets account on the given index
	 * 
	 * @param index
	 * @return Persons person
	 */
	Persons getAccountByIndex(int index);

	/**
	 * gets friends counter of a person
	 * 
	 * @return counter
	 */
	int getFriendsCounter();

	/**
	 * initializes friends iterator
	 */
	void initializeFriendsIterator();

	/**
	 * checks if there are other friends in the array
	 * 
	 * @return true/false
	 */
	boolean hasNextFriend();

	/**
	 * gets current friend
	 * 
	 * @return current friend
	 */
	Persons nextFriend();

	/**
	 * initialise person posts iterator
	 */
	void initializePostsIterator();

	/**
	 * checks if there are other posts in the array
	 * 
	 * @return true/false
	 */
	boolean hasNextPost();

	/**
	 * gets current post
	 * 
	 * @return current post
	 */
	Posts nextPost();
}