/**
 * 
 */
package network;

/**
 * @author 53298
 *
 */
public class PersonsClass implements Persons {

	/**
	 * variables
	 */
	private String name, mail, state;
	private int counterFriends, counterPosts;

	Iterator iteratorFriends, iteratorPosts;
	Persons friends[];
	Posts posts[];

	public PersonsClass(String name, String mail, String state) {
		friends = new PersonsClass[CAPACITY_FRIENDS];
		posts = new PostsClass[CAPACITY_POSTS];
		this.name = name;
		this.mail = mail;
		this.state = state;
		counterFriends = 0;
		counterPosts = 0;
	}

	public PersonsClass(String name, String mail) {
		this.name = name;
		this.mail = mail;
	}

	@Override
	public void addFriend(String name, String mail) {
		friends[counterFriends++] = new PersonsClass(name, mail);
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getMail() {
		return mail;
	}

	@Override
	public String getState() {
		return state;
	}

	@Override
	public void changeState(String state) {
		this.state = state;
	}

	@Override
	public void post(String author, String message, String friend) {
		posts[counterPosts++] = new PostsClass(author, message);
	}

	@Override
	public Persons getAccountByIndex(int index) {
		return friends[index];
	}

	@Override
	public int getFriendsCounter() {
		return counterFriends;
	}

	@Override
	public void initializeFriendsIterator() {
		iteratorFriends = new IteratorClass(friends, counterFriends);
	}

	@Override
	public boolean hasNextFriend() {
		return iteratorFriends.hasNext();
	}

	@Override
	public Persons nextFriend() {
		return iteratorFriends.nextPerson();
	}

	@Override
	public void initializePostsIterator() {
		iteratorPosts = new IteratorClass(posts, counterPosts);
	}

	@Override
	public boolean hasNextPost() {
		return iteratorPosts.hasNext();
	}

	@Override
	public Posts nextPost() {
		return iteratorPosts.nextPost();
	}
}
