package com.example.aquariumapp.utils

import com.android.volley.NetworkResponse
import com.android.volley.ParseError
import com.android.volley.Response
import com.android.volley.toolbox.HttpHeaderParser
import com.android.volley.toolbox.JsonObjectRequest
import org.json.JSONException
import org.json.JSONObject
import java.io.UnsupportedEncodingException

class EmptyResponseBodyRequest(
    statusCode: Int,
    url: String,
    jsonObject: JSONObject?,
    successListener: Response.Listener<JSONObject?>?,
    errorListener: Response.ErrorListener?) : JsonObjectRequest(statusCode, url, jsonObject, successListener, errorListener) {
    override fun parseNetworkResponse(response: NetworkResponse): Response<JSONObject> {
        return try {
            val jsonString = String(
                response.data,
                charset("UTF-8")
            )
            // Allow null
            if (jsonString == null || jsonString.isEmpty()) {
                Response.success(null, HttpHeaderParser.parseCacheHeaders(response))
            } else Response.success(
                JSONObject(jsonString),
                HttpHeaderParser.parseCacheHeaders(response)
            )
        } catch (e: UnsupportedEncodingException) {
            Response.error(ParseError(e))
        } catch (je: JSONException) {
            Response.error(ParseError(je))
        }
    }
}