package com.example.aquariumapp

import android.Manifest
import android.content.Intent
import android.net.wifi.WifiManager
import android.os.Bundle
import android.util.Log
import android.view.ViewGroup
import android.widget.Button
import android.widget.LinearLayout
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.google.firebase.database.FirebaseDatabase
import com.google.firebase.database.ValueEventListener

class AquariumList : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_aquariums_list)

        ActivityCompat.requestPermissions(this,
            arrayOf(Manifest.permission.ACCESS_FINE_LOCATION), 1)

        val database = FirebaseDatabase.getInstance()
        val ref = database.reference

        val postListener = object : ValueEventListener {
            override fun onDataChange(dataSnapshot: DataSnapshot) {
                val mobileSSID = getMobileSSID()
                setRemoteAndLocalViews()
                // Update list of aquariums whenever they change
                val aquariums = dataSnapshot.children
                for (aquarium in aquariums) {
                    displayAquarium(aquarium.key!!,
                        aquarium.child("name").value.toString(),
                        aquarium.child("localIP").value.toString(),
                        aquarium.child("ssid").value.toString(),
                        mobileSSID)
                }
            }

            override fun onCancelled(databaseError: DatabaseError) {
                Log.w("warning", "loadPost:onCancelled", databaseError.toException())
            }
        }
        ref.addValueEventListener(postListener)
    }

    private fun setRemoteAndLocalViews() {
        val views = listOf<LinearLayout>(findViewById(R.id.localList), findViewById(R.id.remoteList))
        for (listView in views) {
            listView.removeAllViews()
        }
    }

    private fun displayAquarium(id: String, name: String, localIP: String, ssid: String,
                                mobileSSID: String) {
        val button = Button(this)
        // setting layout_width and layout_height using layout parameters
        button.layoutParams = LinearLayout.LayoutParams(
            LinearLayout.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.MATCH_PARENT
        )

        button.text = name

        var listViewId = -1
        var remote = false
        if (ssid == mobileSSID) {
            listViewId = R.id.localList
        } else {
            listViewId = R.id.remoteList
            remote = true
        }

        findViewById<LinearLayout>(listViewId).addView(button)

        button.setOnClickListener {
            val intent = Intent(this, AquariumDetails::class.java)
            intent.putExtra("id", id)
            intent.putExtra("remote", remote)
            intent.putExtra("localIP", localIP)
            startActivity(intent)
        }
    }

    private fun getMobileSSID(): String {
        val wifiManager = applicationContext.getSystemService(WIFI_SERVICE) as WifiManager
        val mobileSSID = wifiManager.connectionInfo.ssid // wifi's ssid in between ""
        return mobileSSID.substring(1, mobileSSID.length - 1)
    }
}