/**
 * @author Ricardo Cruz Nr 34951
 * @author Ricardo Gaspar Nr 42038
 * @author Luís Silva Nr 34535
 * Docente: Francisco Azevedo	P4
 */
package circuit;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

//

public class CircuitTest {

	private static String filePath;

	// F1
	private static String typeOfCrossover = RoverCircuit.OX1_CROSSOVER;
	private static String typeOfMutation = RoverCircuit.SWAP_MUTATION;

	private static String stopCriteria = GeneticAlgorithm.INDIVIDUAL_IS_FIT_ENOUGH;
	private static long numberOfGenerationsLimit = GeneticAlgorithm.DEFAULT_STOP_CRITERIA_GENERATION_VALUE;
	private static long timeLimit = GeneticAlgorithm.DEFAULT_STOP_CRITERIA_TIME_VALUE;

	//Não estão a ser utilizados por falta de implementação
	private static boolean isPopulationGenerationRandom = true;
	private static int randomSeed = 0;
	//
	private static boolean isElitismOn = false;

	// F2

	private static int sizeOfInitialPopulation = GeneticAlgorithm.DEFAULT_INITIAL_POPULATION_SIZE;
	private static int eliteSize = GeneticAlgorithm.DEFAULT_ELITE_POPULATION_SIZE;

	private static float crossoverProbability = GeneticAlgorithm.DEFAULT_CROSSOVER_PROBABLITY;
	private static float mutationProbability = GeneticAlgorithm.DEFAULT_MUTATION_PROBABLITY;

	public static void main(String[] args) {

		createGraphicsInterface();

	}

	/**
	 * 
	 */
	public static void runCircuitTest() {

		readAllTextArea();
		ObservationData od = readFile();
		Population pop = generatePopulation(sizeOfInitialPopulation, od,
				typeOfCrossover, typeOfCrossover);
		GeneticAlgorithm ga = new GeneticAlgorithm(pop, crossoverProbability,
				mutationProbability);
		ga.setElitism(isElitismOn, eliteSize);
		series.clear();
		ga.setChartData(series);

		switch (stopCriteria) {
		case GeneticAlgorithm.NO_OF_GENERATIONS_LIMIT:
			ga.setStopCriteria(stopCriteria, numberOfGenerationsLimit);
			break;
		case GeneticAlgorithm.TIME_LIMIT:
			ga.setStopCriteria(stopCriteria, timeLimit);
			break;
		case GeneticAlgorithm.INDIVIDUAL_IS_FIT_ENOUGH:
			ga.setStopCriteria(stopCriteria, 0);
			break;
		case GeneticAlgorithm.POPULATION_IS_FIT_ENOUGH:
			ga.setStopCriteria(stopCriteria, 0);
			break;
		}

		// OUTPUT
		console.setText("");
		StringBuilder output = new StringBuilder();
		output.append("Best Individual FOUND! " + ga.search().toString()
				+ " APPEARED IN: " + ga.getBestFitFirstAppearance()
				+ " GENERATION!\n");
		output.append("Worst Individual fitness: " + ga.getWorstFitness()
				+ " APPEARED IN: " + ga.getWorstFitFirstAppearance() + "\n");
		output.append("TOTAL GENERATIONS: " + ga.getNumberOfGenerations()
				+ "	ELEAPSED TIME: " + ga.getElapsedTime());

		console.setText(output.toString());
	}

	/**
	 * Gerar uma população com um número definido de indivíduos.
	 * 
	 * @param size
	 *            número de indivíduos a gerar.
	 * @param obsData
	 *            dados no ficheiro.
	 * @param typeOfCrossover
	 *            tipo de crossover.
	 * @param typeOfMutation
	 *            tipo de mutação.
	 * @return população.
	 */
	private static Population generatePopulation(int size,
			ObservationData obsData, String typeOfCrossover,
			String typeOfMutation) {
		Individual[] individuals = new Individual[size];
		RoverCircuit rover;
		for (int i = 0; i < individuals.length; i++) {
			rover = new RoverCircuit(obsData, typeOfCrossover, typeOfMutation);
			individuals[i] = rover;

		}
		return new Population(individuals);

	}

	/**
	 * Leitura do ficheiro e criação do ObservationData.
	 * 
	 * @param filePath
	 *            localização do ficheiro no sistema de ficheiros.
	 * @return um ObservationData com os dados do problema.
	 */
	public static ObservationData readFile() {
		String entireFile = null;
		String entireFileToLine = null;
		try {
			entireFileToLine = new Scanner(new File(filePath)).useDelimiter(
					"\\A").next();
			// para os caminhos em windows
			entireFile = entireFileToLine.replace("\r\n", "\n");

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return new ObservationData(entireFile);
	}

	/**
	 * Altera o caminho do ficheiro de dados.
	 * 
	 * @param filePath
	 *            caminho do ficheiro de dados.
	 */
	public static void setFilePath(String newFilePath) {
		// Quando o caminho é um caminho dado pelo windows é necessário trocar \
		// por \\
		filePath = newFilePath.replace("\\", "\\\\");

	}

	// Interface Grafica

	private static JFrame frame;

	public int reset = 0;
	static int value = 0;

	private static final int WIDTH = 1024;
	private static final int HEIGHT = 748;

	private static final int MAX_SLIDER = 100;
	private static final int MIN_SLIDER = 0;

	private static XYSeries series;

	private static JTextField seedTextField;
	private static JTextField stopTextField;
	private static JTextField initPopTextField;
	private static JTextField elitismTextField;
	private static JTextArea console;

	public static void createGraphicsInterface() {
		frame = new JFrame();

		// Sets Interface Size
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setSize(screenSize.width, screenSize.height - 50);
		frame.setLayout(new BorderLayout());

		// Add Main Painel
		frame.add(createMainPanel());

		frame.setTitle("Interface Gráfica");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);

	}

	private static JPanel createMainPanel() {
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		mainPanel.add(createOptionPanel(), BorderLayout.WEST);
		mainPanel.add(createOutputPanel(), BorderLayout.SOUTH);
		mainPanel.add(createGraphPanel(), BorderLayout.CENTER);

		return mainPanel;
	}

	private static JPanel createOptionPanel() {
		JPanel optionPanel = new JPanel();
		optionPanel.setLayout(new GridLayout(4, 1));
		optionPanel.add(createStartMenu());
		optionPanel.add(createCrossoverPanel());
		optionPanel.add(createMutationPanel());
		optionPanel.add(createMoreOptionsPanel());

		return optionPanel;
	}

	private static JPanel createOutputPanel() {
		JPanel outputPanel = new JPanel();
		outputPanel.setBorder(new TitledBorder(new EtchedBorder(), "Console"));
		outputPanel.setLayout(new GridLayout(1, 3));

		console = new JTextArea();
		console.setEditable(false);
		outputPanel.add(console);

		return outputPanel;
	}

	private static JPanel createGraphPanel() {
		series = new XYSeries("Melhor Solução");

		XYSeriesCollection data = new XYSeriesCollection(series);

		final JFreeChart chart = ChartFactory.createXYLineChart(
				"Algoritmo genético", "Nº de Gerações", "Fitness", data,
				PlotOrientation.VERTICAL, true, true, false);
		final ChartPanel chartPanel = new ChartPanel(chart);

		return chartPanel;
	}

	private static JPanel createStartMenu() {
		JPanel startPanel = new JPanel();
		startPanel
				.setBorder(new TitledBorder(new EtchedBorder(), "Start Menu:"));
		startPanel.setLayout(new GridLayout(4, 1));

		// Browse Menu

		JLabel startLabel = new JLabel("File Path :");

		final JTextField filePathTextField = new JTextField(10);
		filePathTextField.setText("File not selected.");
		filePathTextField.setEditable(false);

		JButton filePathChooseButton = new JButton("File Load");

		class filePathButtonListener implements ActionListener {

			@Override
			public void actionPerformed(ActionEvent event) {

				JFileChooser fileChooser = new JFileChooser();

				fileChooser
						.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				fileChooser.setCurrentDirectory(new File(System
						.getProperty("user.dir")));
				fileChooser.showOpenDialog(frame);
				File file = null;
				try {
					file = fileChooser.getSelectedFile();
					// Altera o caminho do ficheiro
					setFilePath(file.getAbsolutePath());
					// Mostra na janela o nome do ficheiro
					filePathTextField.setText(file.getName());
				} catch (Exception e) {
				}

			}

		}
		;

		filePathChooseButton.addActionListener(new filePathButtonListener());

		startPanel.add(filePathTextField);
		startPanel.add(filePathChooseButton);

		JButton startButton = new JButton("START");

		class startButonListener implements ActionListener {

			@Override
			public void actionPerformed(ActionEvent e) {
				runCircuitTest();

			}
		}
		;

		startButton.addActionListener(new startButonListener());

		startPanel.add(startLabel);
		startPanel.add(filePathTextField);
		startPanel.add(filePathChooseButton);
		startPanel.add(startButton);

		return startPanel;

	}

	/**
	 * @return
	 */
	private static JPanel createCrossoverPanel() {
		JPanel crossoverPanel = new JPanel();
		crossoverPanel.setBorder(new TitledBorder(new EtchedBorder(),
				"CrossOver:"));
		crossoverPanel.setLayout(new GridLayout(4, 1));

		// CrossOver Options
		JLabel crossoverLabel = new JLabel("CrossOver Type:");

		String[] crossoverTypes = { RoverCircuit.OX1_CROSSOVER,
				RoverCircuit.OX2_CROSSOVER, RoverCircuit.PMX_CROSSOVER };

		JComboBox crossoverList = new JComboBox(crossoverTypes);

		// Listener Class
		class listsAction implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox) e.getSource();
				String newSelection = (String) cb.getSelectedItem();

				switch (newSelection) {
				case RoverCircuit.OX1_CROSSOVER:
					typeOfCrossover = newSelection;
					break;
				case RoverCircuit.OX2_CROSSOVER:
					typeOfCrossover = newSelection;
					break;
				case RoverCircuit.PMX_CROSSOVER:
					typeOfCrossover = newSelection;
					break;
				default:
					break;
				}
			}
		}

		// CrossOver Slider

		JSlider crossover = new JSlider(MIN_SLIDER, MAX_SLIDER,
				(int) GeneticAlgorithm.DEFAULT_CROSSOVER_PROBABLITY);
		// Turn on labels at major tick marks.
		crossover.setMajorTickSpacing(50);
		crossover.setMinorTickSpacing(10);
		crossover.setPaintTicks(true);
		crossover.setPaintLabels(true);

		final JLabel probabilityLabel = new JLabel("Probability : "
				+ crossover.getValue());

		// Listener Class, Also updates de JLabel with current value
		class sliderListener implements ChangeListener {

			public void stateChanged(ChangeEvent event) {
				// Source with Slider Value
				JSlider source = (JSlider) event.getSource();
				int value = source.getValue();
				crossoverProbability = value;
				// Update the Label
				probabilityLabel.setText("Probability : " + source.getValue());


			}
		}

		crossover.addChangeListener(new sliderListener());

		// Adds comp's to panel
		crossoverPanel.add(crossoverLabel);
		crossoverPanel.add(crossoverList);
		crossoverPanel.add(probabilityLabel);
		crossoverPanel.add(crossover);

		return crossoverPanel;

	}

	/**
	 * @return
	 */
	private static JPanel createMutationPanel() {
		JPanel mutationPanel = new JPanel();
		mutationPanel.setBorder(new TitledBorder(new EtchedBorder(),
				"Mutation:"));
		mutationPanel.setLayout(new GridLayout(4, 1));

		// Mutation Options
		JLabel mutationrLabel = new JLabel("Mutation Type:");

		String[] mutationTypes = { RoverCircuit.SWAP_MUTATION,
				RoverCircuit.INSERT_MUTATION, RoverCircuit.SHIFT_MUTATION,
				RoverCircuit.INVERT_MUTATION };

		JComboBox mutationList = new JComboBox(mutationTypes);

		// Listener Class
		class listsAction implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox) e.getSource();
				String newSelection = (String) cb.getSelectedItem();

				switch (newSelection) {
				case RoverCircuit.SWAP_MUTATION:
					typeOfMutation = newSelection;
					break;
				case RoverCircuit.INSERT_MUTATION:
					typeOfMutation = newSelection;
					break;
				case RoverCircuit.SHIFT_MUTATION:
					typeOfMutation = newSelection;
					break;
				case RoverCircuit.INVERT_MUTATION:
					typeOfMutation = newSelection;
					break;
				default:
					break;
				}

			}
		}

		mutationList.addActionListener(new listsAction());

		// Mutation Slider

		JSlider mutationSlider = new JSlider(MIN_SLIDER, MAX_SLIDER,
				(int) GeneticAlgorithm.DEFAULT_MUTATION_PROBABLITY);
		// Turn on labels at major tick marks.
		mutationSlider.setMajorTickSpacing(50);
		mutationSlider.setMinorTickSpacing(10);
		mutationSlider.setPaintTicks(true);
		mutationSlider.setPaintLabels(true);
		// mutation.setBounds(110, 0, 100, 50);

		final JLabel probabilityLabel = new JLabel("Probability : "
				+ mutationSlider.getValue());
		// sliderLabel.setBounds(110, 30, 100, 50);

		// Listener Class, Also updates de JLabel with current value
		class sliderListener implements ChangeListener {

			public void stateChanged(ChangeEvent event) {
				// Source with Slider Value
				JSlider source = (JSlider) event.getSource();
				int value = source.getValue();
				mutationProbability = value;
				// Update the Label
				probabilityLabel.setText("Probability : " + source.getValue());

			}
		}

		mutationSlider.addChangeListener(new sliderListener());

		// Adds comp's to panel
		mutationPanel.add(mutationrLabel);
		mutationPanel.add(mutationList);
		mutationPanel.add(probabilityLabel);
		mutationPanel.add(mutationSlider);

		return mutationPanel;

	}

	private static JPanel createMoreOptionsPanel() {
		JPanel moreOptionsPanel = new JPanel();
		moreOptionsPanel.setBorder(new TitledBorder(new EtchedBorder(),
				"More Options:"));
		moreOptionsPanel.setLayout(new GridLayout(8, 1));

		// Stop condition label and list
		JLabel stopLabel = new JLabel("Stop Condition :");

		stopTextField = new JTextField(10);
		stopTextField.setEditable(false);

		String[] stopTypes = { GeneticAlgorithm.INDIVIDUAL_IS_FIT_ENOUGH,
				GeneticAlgorithm.NO_OF_GENERATIONS_LIMIT,
				GeneticAlgorithm.TIME_LIMIT,
				GeneticAlgorithm.POPULATION_IS_FIT_ENOUGH };

		JComboBox stopList = new JComboBox(stopTypes);

		// Listener Class
		class listsAction implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox) e.getSource();
				String newSelection = (String) cb.getSelectedItem();

				stopCriteria = newSelection;

				switch (stopCriteria) {
				case GeneticAlgorithm.NO_OF_GENERATIONS_LIMIT:
					stopTextField
							.setText(""
									+ GeneticAlgorithm.DEFAULT_STOP_CRITERIA_GENERATION_VALUE);
					stopTextField.setEditable(true);
					break;
				case GeneticAlgorithm.TIME_LIMIT:
					stopTextField
							.setText(""
									+ GeneticAlgorithm.DEFAULT_STOP_CRITERIA_TIME_VALUE);
					stopTextField.setEditable(true);
					break;
				case GeneticAlgorithm.INDIVIDUAL_IS_FIT_ENOUGH:

					stopTextField.setEditable(false);
					break;
				case GeneticAlgorithm.POPULATION_IS_FIT_ENOUGH:
					stopTextField.setEditable(false);
					break;
				}

			}
		}

		stopList.addActionListener(new listsAction());

		// Initial Population

		JLabel initPopLabel = new JLabel(
				"Initial Population Size (Even numbers):");

		initPopTextField = new JTextField(10);
		initPopTextField.setText(""
				+ GeneticAlgorithm.DEFAULT_INITIAL_POPULATION_SIZE);

		// Elitism

		JLabel elitismLabel = new JLabel("Elitism Size (Even numbers):");

		elitismTextField = new JTextField(10);
		elitismTextField.setEditable(false);

		// Elitism Check

		JCheckBox elitismCheckBox = new JCheckBox("Elitism");

		class elitismListener implements ActionListener {

			@Override
			public void actionPerformed(ActionEvent e) {
				JCheckBox cb = (JCheckBox) e.getSource();
				boolean isSelected = cb.isSelected();

				if (isSelected) {
					isElitismOn = true;
					elitismTextField.setText(""
							+ GeneticAlgorithm.DEFAULT_ELITE_POPULATION_SIZE);
					elitismTextField.setEditable(true);

				} else {
					isElitismOn = true;
					elitismTextField.setEditable(false);
				}

			}

		}

		elitismCheckBox.addActionListener(new elitismListener());

		moreOptionsPanel.add(stopLabel);
		moreOptionsPanel.add(stopTextField);
		moreOptionsPanel.add(stopList);
		moreOptionsPanel.add(initPopLabel);
		moreOptionsPanel.add(initPopTextField);
		moreOptionsPanel.add(elitismLabel);
		moreOptionsPanel.add(elitismCheckBox);
		moreOptionsPanel.add(elitismTextField);

		return moreOptionsPanel;

	}

	/**
	 * Lê todas as caixas de texto e actualiza as respectivas variáveis.
	 */
	private static void readAllTextArea() {

		try {
			numberOfGenerationsLimit = checkEvenNumber(Integer
					.parseInt(stopTextField.getText()));
			stopTextField.setText("" + numberOfGenerationsLimit);
		} catch (Exception e) {
			numberOfGenerationsLimit = GeneticAlgorithm.DEFAULT_STOP_CRITERIA_GENERATION_VALUE;
		}

		try {
			timeLimit = checkEvenNumber(Integer.parseInt(stopTextField
					.getText()));
			stopTextField.setText("" + timeLimit);
		} catch (Exception e) {
			timeLimit = GeneticAlgorithm.DEFAULT_STOP_CRITERIA_TIME_VALUE;
		}

		try {
			sizeOfInitialPopulation = checkEvenNumber(Integer
					.parseInt(initPopTextField.getText()));
			initPopTextField.setText("" + sizeOfInitialPopulation);
		} catch (Exception e) {
			sizeOfInitialPopulation = GeneticAlgorithm.DEFAULT_INITIAL_POPULATION_SIZE;
		}

		try {
			eliteSize = checkEvenNumber(Integer.parseInt(elitismTextField
					.getText()));
			elitismTextField.setText("" + eliteSize);
		} catch (Exception e) {
			eliteSize = GeneticAlgorithm.DEFAULT_ELITE_POPULATION_SIZE;
		}

		// Para o caso de a dimensão da elite ser maior que o tamanho da
		// população inicial
		if (eliteSize > sizeOfInitialPopulation) {
			eliteSize = (int) (sizeOfInitialPopulation - 2);
			elitismTextField.setText("" + eliteSize);
		}

	}

	/**
	 * Verifica se um dado número é par e devolve um número par. Caso não seja,
	 * devolve o próximo par.
	 * 
	 * @param number
	 *            número inteiro.
	 * @return Caso o número seja par devolve-o. Caso contrário, devolve o
	 *         próximo par.
	 */
	private static int checkEvenNumber(int number) {
		if (number % 2 != 0)
			return number + 1;
		else
			return number;
	}

}
