/**
 * @author Ricardo Cruz Nr 34951
 * @author Ricardo Gaspar Nr 42038
 * @author Luís Silva Nr 34535
 * Docente: Francisco Azevedo	P4
 */
package circuit;

import java.util.*;

import circuit.ObservationData.ObservationSpot;

/**
 * Classe que instancia a classe abstracta Individual
 */
public class RoverCircuit extends Individual {
	// Crossover constants
	public static final String OX1_CROSSOVER = "OX1";
	public static final String OX2_CROSSOVER = "OX2";
	public static final String PMX_CROSSOVER = "PMX";
	private String typeOfCrossover;

	// Mutation constants
	public static final String SWAP_MUTATION = "SWAP";
	public static final String INSERT_MUTATION = "INSERT";
	public static final String SHIFT_MUTATION = "SHIFT";
	public static final String INVERT_MUTATION = "INVERT";
	private String typeOfMutation;

	private ObservationSpot[] spots;
	private ObservationData circuitObsData;
	private double fitness;

	public RoverCircuit(ObservationData obsData, String typeOfCrossover,
			String typeOfMutation) {
		circuitObsData = obsData;
		// converter para lista para poder aplicar o shuffle, caso true
		ArrayList<ObservationSpot> tempSpots = new ArrayList<>(
				Arrays.asList(circuitObsData.spots));
		Collections.shuffle(tempSpots);
		// guardar o array após o shuffle
		spots = new ObservationSpot[tempSpots.size()];
		tempSpots.toArray(spots);
		fitness = -1;

		this.typeOfCrossover = typeOfCrossover;
		this.typeOfMutation = typeOfMutation;
	}

	/**
	 * Construtor sem shuffle. Para ser utilizado pelo clone() e crossover().
	 * 
	 * @param obsData
	 *            Dados acerca dos pontos e dos custos.
	 * @param parentSpots
	 *            pontos do pai.
	 */
	public RoverCircuit(ObservationData obsData, ObservationSpot[] parentSpots,
			String typeOfCrossover, String typeOfMutation) {
		circuitObsData = obsData;
		spots = parentSpots;
		fitness = -1;

		this.typeOfCrossover = typeOfCrossover;
		this.typeOfMutation = typeOfMutation;
	}

	@Override
	public double fitness() {
		if (fitness != -1)
			return fitness;
		fitness = 0;

		for (int i = 0, time = 0; i < circuitObsData.getSize(); i++) {
			String namei = spots[i].getName();
			String namej;
			// no caso de ser o ultimo ponto ver o custo ate ao primeiro
			if (i == circuitObsData.getSize() - 1) {
				namej = spots[0].getName();
				fitness += spots[i].durationObservation(time)
						+ circuitObsData.getCost(costIndex(namei),
								costIndex(namej));

			} else {
				namej = circuitObsData.getSpot(i + 1).getName();

				fitness += spots[i].durationObservation(time)
						+ circuitObsData.getCost(costIndex(namei),
								costIndex(namej));
			}
			time = (int) fitness;
		}

		return fitness;
	}

	@Override
	public Individual[] crossover(Individual other) {
		switch (typeOfCrossover) {
		case OX1_CROSSOVER:
			return oXcrossOver(other);
		default:
			return oXcrossOver(other); // faltam +opções
		}
	}

	@Override
	public void mutate() {
		// repõe o valor de fitness para que o volte a calcular aquando da
		// chamada do método fitness()
		fitness = -1;

		switch (typeOfMutation) {
		case SWAP_MUTATION:
			swapMutation();
		default:
			swapMutation(); // faltam +opções
		}

	}

	@Override
	public Object clone() {
		// false para não fazer shuffle
		return new RoverCircuit(circuitObsData, spots.clone(), this.typeOfCrossover,
				this.typeOfMutation);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder path = new StringBuilder();
		for (int i = 0; i < spots.length; i++) {
			path.append(spots[i].getName() + " ");
		}
		return "Fitness: " + fitness() + " spots: " + path;
	}

	/**
	 * Mutação por troca.
	 */
	private void swapMutation() {
		Random rand = new Random();
		int pos1 = rand.nextInt(circuitObsData.getSize());
		int pos2;

		do {
			pos2 = rand.nextInt(circuitObsData.getSize());
		} while (pos1 == pos2);

		ObservationSpot tempSpot = spots[pos1];
		spots[pos1] = spots[pos2];
		spots[pos2] = tempSpot;
	}

	/**
	 * Faz o parsing do nome de um ponto, por forma a obter o nr do ponto.
	 * 
	 * @param name
	 *            nome do ponto
	 * @return Número (index) do ponto.
	 */
	private int costIndex(String name) {

		return Integer.parseInt(name.substring(1));
	}

	/**
	 * @param other
	 * @return
	 */
	private Individual[] oXcrossOver(Individual other) {
		int size = circuitObsData.getSize();
		Random rand = new Random();
		int pos1, cut1;
		int pos2, cut2;
		// Define os pontos de corte. Assume se que o corte é feito atrás do
		// indice
		do {
			pos1 = rand.nextInt(size - 1) + 1;
			pos2 = rand.nextInt(size - 1) + 1;
		} while (pos1 == pos2);

		cut1 = Math.min(pos1, pos2);
		cut2 = Math.max(pos1, pos2);

		ObservationSpot[] parent1 = ((RoverCircuit) other).spots;
		ObservationSpot[] child1Spots = new ObservationSpot[parent1.length];
		ObservationSpot[] child2Spots = new ObservationSpot[this.spots.length];

		System.arraycopy(parent1, cut1, child1Spots, cut1, cut2 - cut1);
		System.arraycopy(this.spots, cut1, child2Spots, cut1, cut2 - cut1);

		LinkedHashSet<ObservationSpot> setOfChild1 = new LinkedHashSet<>(
				Arrays.asList(child1Spots));
		LinkedHashSet<ObservationSpot> setOfChild2 = new LinkedHashSet<>(
				Arrays.asList(child2Spots));

		// Create child2 based on parent1
		int i = cut2, j = cut2;
		boolean check = false;
		while (!check) {
			i = i % size;
			j = j % size;

			if (!setOfChild2.contains(parent1[j])) {
				child2Spots[i] = parent1[j];
				i++;
				j++;
			} else {
				j++;
			}

			if (i == cut1)
				check = true;
		}

		// Create child1 based on parent2 (this)
		i = cut2;
		j = cut2;
		check = false;
		while (!check) {
			i = i % size;
			j = j % size;

			if (!setOfChild1.contains(this.spots[j])) {
				child1Spots[i] = this.spots[j];
				i++;
				j++;
			} else {
				j++;
			}

			if (i == cut1)
				check = true;
		}

		RoverCircuit child1 = new RoverCircuit(circuitObsData, child1Spots,
				this.typeOfCrossover, this.typeOfMutation);
		RoverCircuit child2 = new RoverCircuit(circuitObsData, child2Spots,
				this.typeOfCrossover, this.typeOfMutation);

		RoverCircuit[] children = { child1, child2 };

		return children;

	}
	
}
