/**
 * @author Ricardo Cruz Nr 34951
 * @author Ricardo Gaspar Nr 42038
 * @author Luis Silva Nr 34535
 * Docente: Francisco Azevedo	P4
 */

package circuit;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.*;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;




public class InterfaceGrafica extends JFrame {

	private static final long serialVersionUID = 1L;
	public int reset = 0;
	static int value = 0;

	private static final int WIDTH = 1024;
	private static final int HEIGHT = 748;

	private static final int MAX_SLIDER = 100;
	private static final int MIN_SLIDER = 0;
	private static final int SLIDER_DEFAULT = 5;
	private static XYSeries series;
	private static XYSeries series2;
	
	private static JFrame frame;
	
	
//	public JMenuBar navBar;
	GridBagLayout gridbag = new GridBagLayout();

	public InterfaceGrafica() {
		// Sets Interface Size
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		setSize(screenSize.width, screenSize.height - 50);
//		setSize(WIDTH, HEIGHT);
//		setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		frame = this;

		setLayout(new BorderLayout());

		// Add Main Painel
		add(createMainPanel());
		
	   

		// TESTES!!!!!!!!!!!
		// ct.setFilePath("C:\\Users\\Luis Silva\\Dropbox\\Luis Silva\\FCT\\3 Ano\\1º Semestre\\IA - Inteligencia Artificial\\workspace\\ia-tp1b\\src\\circuit\\CincoLinha.txt");
		// CircuitTest.readFile();
		// ct.runCircuitTest();
		// ct.runCircuitTest();
	}
		

	private static JPanel createMainPanel() {
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		mainPanel.add(createOptionPanel(), BorderLayout.WEST);
		mainPanel.add(createGraphPanel(), BorderLayout.CENTER);

		return mainPanel;
	}

	private static JPanel createOptionPanel() {
		JPanel optionPanel = new JPanel();
		optionPanel.setLayout(new GridLayout(4, 1));
		// optionPanel.setSize(width, height)
		optionPanel.add(createStartMenu());
		optionPanel.add(createCrossoverPanel());
		optionPanel.add(createMutationPanel());
		optionPanel.add(createMoreOptionsPanel());

		return optionPanel;
	}

	private static JPanel createGraphPanel() {
		//JPanel graphPanel = new JPanel();
		series = new XYSeries("Melhor Solução");
	    series2 = new XYSeries("Média Fitness");

	    final XYSeriesCollection data = new XYSeriesCollection(series);
	    data.addSeries(series2);
	    final JFreeChart chart = ChartFactory.createXYLineChart(
	            "Algoritmo genético",
	            "Nº de Gerações", 
	            "Fitness", 
	            data,
	            PlotOrientation.VERTICAL,
	            true,
	            true,
	            false
	        );
		 final ChartPanel chartPanel = new ChartPanel(chart);
		 
		return chartPanel;
	}
	
	public static void addChartValues1 (double x, double y){
		series.add(x, y);
	}
	
	public static void addChartValues2 (double x, double y){
		series2.add(x, y);
	}

	private static JPanel createStartMenu() {
		JPanel startPanel = new JPanel();
		startPanel
				.setBorder(new TitledBorder(new EtchedBorder(), "Start Menu:"));
		startPanel.setLayout(new GridLayout(4, 1));
		
		//RAND
		
		JCheckBox randCheckBox = new JCheckBox("Random");
		
		class randListener implements ActionListener{

			@Override
			public void actionPerformed(ActionEvent e) {
				
			}
			
		}
		
		randCheckBox.addActionListener(new randListener());

		// SEED

		JLabel seedLabel = new JLabel("Seed :");

		final JTextField seedTextField = new JTextField(10);

		class seedListener implements ActionListener {

			@Override
			public void actionPerformed(ActionEvent e) {
				int seedValue = Integer.parseInt(seedTextField.getText());

			}

		}

		seedTextField.addActionListener(new seedListener());
		
		//Browse Menu
		
		JLabel startLabel = new JLabel("File Path :");
		
		final JTextField filePathTextField = new JTextField(10);
		filePathTextField.setText("File not selected.");
		filePathTextField.setEditable(false);

		JButton filePathChooseButton = new JButton("File Load");

		class filePathButtonListener implements ActionListener {

			@Override
			public void actionPerformed(ActionEvent event) {

				JFileChooser fileChooser = new JFileChooser();
				
				fileChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
//				fileChooser.showSaveDialog(this);
				fileChooser.showOpenDialog(frame);
				File file = null;
				try {
					file = fileChooser.getSelectedFile();
					filePathTextField.setText(file.getName());
				} catch (Exception e) {
				}

				System.out.println(file.getAbsolutePath());
			}

		};
		
		filePathChooseButton.addActionListener(new filePathButtonListener());
		
		
		
		startPanel.add(filePathTextField);
		startPanel.add(filePathChooseButton);
		
		JButton startButton = new JButton("START");
		
		class startButonListener implements ActionListener{

			@Override
			public void actionPerformed(ActionEvent e) {
				// TODO Auto-generated method stub
				
			}
		};
		
		startButton.addActionListener(new startButonListener());
		
		startPanel.add(startLabel);
		startPanel.add(filePathTextField);
		startPanel.add(filePathChooseButton);
		startPanel.add(startButton);
		startPanel.add(seedLabel);
		startPanel.add(seedTextField);
		startPanel.add(randCheckBox);
		
		return startPanel;

	}

	/**
	 * @return
	 */
	private static JPanel createCrossoverPanel() {
		JPanel crossoverPanel = new JPanel();
		crossoverPanel.setBorder(new TitledBorder(new EtchedBorder(),
				"CrossOver:"));
		crossoverPanel.setLayout(new GridLayout(4, 1));

		// CrossOver Options
		JLabel crossoverLabel = new JLabel("CrossOver Type:");

		String[] crossoverTypes = { "OX1", "OX2", "PMX" };

		JComboBox crossoverList = new JComboBox(crossoverTypes);

		// Listener Class
		class listsAction implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox) e.getSource();
				String newSelection = (String) cb.getSelectedItem();

				if (newSelection.equals("OX1")) {
					System.out.println("OX1");
				} else if (newSelection.equals("OX2")) {
					System.out.println("OX2");
				} else if (newSelection.equals("PMX")) {
					System.out.println("PMX");
				}
			}
		}

		// CrossOver Slider

		JSlider crossover = new JSlider(MIN_SLIDER, MAX_SLIDER, SLIDER_DEFAULT);
		// Turn on labels at major tick marks.
		crossover.setMajorTickSpacing(50);
		crossover.setMinorTickSpacing(10);
		crossover.setPaintTicks(true);
		crossover.setPaintLabels(true);
		// crossover.setBounds(110, 70, 100, 50);

		final JLabel probabilityLabel = new JLabel("Probability : "
				+ crossover.getValue());

		// Listener Class, Also updates de JLabel with current value
		class sliderListener implements ChangeListener {

			public void stateChanged(ChangeEvent event) {
				// Source with Slider Value
				JSlider source = (JSlider) event.getSource();
				int value = source.getValue();
				// Update the Label
				probabilityLabel.setText("Probability : " + source.getValue());

				// System.out.println("Slider Val: " + value);

			}
		}

		crossover.addChangeListener(new sliderListener());

		// Adds comp's to panel
		crossoverPanel.add(crossoverLabel);
		crossoverPanel.add(crossoverList);
		crossoverPanel.add(probabilityLabel);
		crossoverPanel.add(crossover);

		return crossoverPanel;

	}

	/**
	 * @return
	 */
	private static JPanel createMutationPanel() {
		JPanel mutationPanel = new JPanel();
		mutationPanel.setBorder(new TitledBorder(new EtchedBorder(),
				"Mutation:"));
		mutationPanel.setLayout(new GridLayout(4, 1));

		// Mutation Options
		JLabel mutationrLabel = new JLabel("Mutation Type:");

		String[] mutationTypes = { "Swap", "Insert", "Shift",
				"Invert" };

		JComboBox mutationList = new JComboBox(mutationTypes);

		// Listener Class
		class listsAction implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox) e.getSource();
				String newSelection = (String) cb.getSelectedItem();

				if (newSelection.equals("Swap")) {
					System.out.println("Swap");
				} else if (newSelection.equals("Insert")) {
					System.out.println("Insert");
				} else if (newSelection.equals("Shift")) {
					System.out.println("Shift");
				} else if (newSelection.equals("Invert")) {
					System.out.println("Invert");
				}

			}
		}

		mutationList.addActionListener(new listsAction());

		// Mutation Slider

		JSlider mutationSlider = new JSlider(MIN_SLIDER, MAX_SLIDER,
				SLIDER_DEFAULT);
		// Turn on labels at major tick marks.
		mutationSlider.setMajorTickSpacing(50);
		mutationSlider.setMinorTickSpacing(10);
		mutationSlider.setPaintTicks(true);
		mutationSlider.setPaintLabels(true);
		// mutation.setBounds(110, 0, 100, 50);

		final JLabel probabilityLabel = new JLabel("Probability : "
				+ mutationSlider.getValue());
		// sliderLabel.setBounds(110, 30, 100, 50);

		// Listener Class, Also updates de JLabel with current value
		class sliderListener implements ChangeListener {

			public void stateChanged(ChangeEvent event) {
				// Source with Slider Value
				JSlider source = (JSlider) event.getSource();
				int value = source.getValue();
				// Update the Label
				probabilityLabel.setText("Probability : " + source.getValue());

				System.out.println("Slider Val: " + value);

			}
		}

		mutationSlider.addChangeListener(new sliderListener());

		// Adds comp's to panel
		mutationPanel.add(mutationrLabel);
		mutationPanel.add(mutationList);
		mutationPanel.add(probabilityLabel);
		mutationPanel.add(mutationSlider);

		return mutationPanel;

	}

	private static JPanel createMoreOptionsPanel() {
		JPanel moreOptionsPanel = new JPanel();
		moreOptionsPanel.setBorder(new TitledBorder(new EtchedBorder(),
				"More Options:"));
		moreOptionsPanel.setLayout(new GridLayout(7, 1));

		// Stop condition label and list
		JLabel stopLabel = new JLabel("Stop Condition :");

		final JTextField stopTextField = new JTextField(10);

		String[] stopTypes = { "Generations number", "Time Limit",
				"Fitness Stabilization ", "Merit function" };

		JComboBox stopList = new JComboBox(stopTypes);

		// Listener Class
		class listsAction implements ActionListener {

			public void actionPerformed(ActionEvent e) {
				JComboBox cb = (JComboBox) e.getSource();
				String newSelection = (String) cb.getSelectedItem();

				if (newSelection.equals("Generations number")) {
					System.out.println("Generations number");
				} else if (newSelection.equals("Time Limit")) {
					System.out.println("Time Limit");
				} else if (newSelection.equals("Fitness Stabilization")) {
					System.out.println("Fitness Stabilization");
				} else if (newSelection.equals("Merit function")) {
					System.out.println("Merit function");
				}

			}
		}

		stopList.addActionListener(new listsAction());

		// Initial Population

		JLabel initPopLabel = new JLabel("Initial Population Size :");

		final JTextField initPopTextField = new JTextField(10);

		class initPopListener implements ActionListener {

			@Override
			public void actionPerformed(ActionEvent e) {
				int initPopValue = Integer.parseInt(initPopTextField.getText());

			}

		}

		initPopTextField.addActionListener(new initPopListener());

		// Elitism

		JLabel elitismLabel = new JLabel("Elitism Size :");

		final JTextField elitismTextField = new JTextField(10);

		class elitismListener implements ActionListener {

			@Override
			public void actionPerformed(ActionEvent e) {
				int elitismValue = Integer.parseInt(elitismTextField.getText());

			}

		}

		elitismTextField.addActionListener(new initPopListener());

		moreOptionsPanel.add(stopLabel);
		moreOptionsPanel.add(stopList);
		moreOptionsPanel.add(stopTextField);
		moreOptionsPanel.add(initPopLabel);
		moreOptionsPanel.add(initPopTextField);
		moreOptionsPanel.add(elitismLabel);
		moreOptionsPanel.add(elitismTextField);

		return moreOptionsPanel;

	}


}
