package example;

public class ElementClass implements Element {
	private int value;
	private String id;
	
	public ElementClass(String id, int amount) {
		this.id = id;
		value = amount;
	}

	public void incValue(int amount) {
		value += amount;
	}

	public int getValue() {
		return value;
	}

	public String getId() {
		return id;
	}

	public int compareTo(Element other) {
		// Compare by value, then by id
		int thisValue = this.getValue();
		int otherValue = other.getValue();
		if (thisValue == otherValue)
			return this.getId().compareTo(other.getId());
		return thisValue - otherValue;
	}
	
	public String toString() {
		return "(" + getId() + "," + getValue() + ")";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Element))
			return false;
		Element other = (Element) obj;
		if (id == null) {
			if (other.getId() != null)
				return false;
		} else if (!id.equals(other.getId()))
			return false;
		return true;
	}

}
