package example;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class MyCollectionClass implements MyCollection {
	private static final int DIMENSION = 20;
	private Map<String,Element> elems;
	private SortedSet<Element> tree;
	
	public MyCollectionClass() {
		elems = new HashMap<>(DIMENSION);
		tree = new TreeSet<>();
	}
	
	public void add(String id, int amount) {
		Element elem = new ElementClass(id,amount);
		elems.put(id,elem);
		tree.add(elem);
	}

	public void incValue(String id, int amount) {
		Element e = elems.get(id);
		tree.remove(e); // Essencial to remove the element before updating value
		e.incValue(amount);
		tree.add(e);
	}

	public Iterator<Element> listAll() {
		return tree.iterator();
	}

}
