package marsattack;

public class YodellersArmy {
	public static final int MAX_SOLDIERS = 50;
	private Soldier[] yodellers; // vector do exrcito dos yodellers

	private int counter; // nmero de soldados Yodeller no vector
	private int current; // posio do soldado Yodeller corrente

	public YodellersArmy() {
		counter = 0;
		yodellers = new Soldier[MAX_SOLDIERS];
		current = -1;
	}
	
	/** Iterador que inicializa a travessia do vector.*/
	public void initializeIterator() {
		if (counter > 0)
			current = 0;
		else
			current = -1;
	}
	
	/** Iterador que verifica a existncia de um prximo soldado Yodeller no vector.*/
	public boolean hasNext() {
		return ((current >= 0) && (current < counter));
	}

	/** Iterador que devolve o soldado corrente do vector*/
	public Soldier next() {
		Soldier yodeller = null;
		if (this.hasNext())
			yodeller = yodellers[current++];
		return yodeller;
	}

	/** Mtodo para criar um soldado Yodeller.*/
	public void create(String name, int coordX, int coordY, String orientation,
			double experience) {
		boolean isAlive = true;
		if (searchIndex(name) == -1) { // novo soldado Yodeller
			if (counter == yodellers.length) { // vector cheio
				Soldier tmp[] = new Soldier[2 * yodellers.length];
				int i = 0;
				while (i < counter) {
					tmp[i] = yodellers[i];
					i++;
				}
				yodellers = tmp;
			}
			yodellers[counter] = new Soldier(name, coordX, coordY, orientation,
					experience, isAlive);
			counter++;
		}
	}

	/** Mtodo para realizar um movimento.*/
	public int move(String name, String orientation, int coordX, int coordY) {
		int index = searchIndex(name);
		if (index != -1) { // yodeller existente
			yodellers[index].setMove(orientation, coordX, coordY); // altera a
																	// posio
		}
		return index;
	}
	
	/** Mtodo para realizar um ataque.*/
	public int attack(String name, MartiansArmy martians) {

		int indexYodeller = searchIndex(name);
		int x;
		int y;
		int tempKills = 0;
		double radius;

		if ((indexYodeller != -1) && (yodellers[indexYodeller].getIsAlive())) {
			// Se o nome introduzido for vlido e se o yodeller em questo
			// estiver vivo
			x = yodellers[indexYodeller].getCoordX();
			y = yodellers[indexYodeller].getCoordY();
			radius = yodellers[indexYodeller].getExperience();

			tempKills = martians.attacked(x, y, radius);

			yodellers[indexYodeller].setKills(tempKills);
			yodellers[indexYodeller].setExperience(tempKills * 0.05
					* yodellers[indexYodeller].getExperience());
		}
		return tempKills;
	}

	/** Mtodo para registar quais os soldados afectados pelo ataque do inimigo.*/
	public int attacked(int xMartian, int yMartian, String orientationMartian,
			double rangeMartian) {
		int killed = 0;
		int indexYodeller = -1;
		double closer = Double.MAX_VALUE;
		for (int i = 0; i < counter; i++) {
			int xYodeller = yodellers[i].getCoordX();
			int yYodeller = yodellers[i].getCoordY();
			double rangeYodeller = Math.sqrt(Math.pow(xYodeller - xMartian, 2)
					+ Math.pow(yYodeller - yMartian, 2));

			if (orientationMartian.equals("Norte")
					&& (yYodeller > yMartian)
					&& ((yodellers[i].getIsAlive()) && (rangeYodeller <= rangeMartian))) {
				if (rangeYodeller < closer) {
					closer = rangeYodeller;
					indexYodeller = i;
				}
			} else if (orientationMartian.equals("Sul")
					&& (yYodeller < yMartian)
					&& ((yodellers[i].getIsAlive()) && (rangeYodeller <= rangeMartian))) {
				if (rangeYodeller < closer) {
					closer = rangeYodeller;
					indexYodeller = i;
				}
			} else if (orientationMartian.equals("Este")
					&& (xYodeller > xMartian)
					&& ((yodellers[i].getIsAlive()) && (rangeYodeller <= rangeMartian))) {
				if (rangeYodeller < closer) {
					closer = rangeYodeller;
					indexYodeller = i;
				}
			} else if (orientationMartian.equals("Oeste")
					&& (xYodeller < xMartian)
					&& ((yodellers[i].getIsAlive()) && (rangeYodeller <= rangeMartian))) {
				if (rangeYodeller < closer) {
					closer = rangeYodeller;
					indexYodeller = i;
				}
			}

			if (indexYodeller != -1) {
				killed = 1;
				yodellers[indexYodeller].setIsAlive(false);
			}
		}
		return killed;
	}

	/** Mtodo para verificar a existncia de um soldado dado o seu nome.*/
	public boolean yodellerExists(String name)
	{
		return (searchIndex(name)!=-1);
	}
	
	/** Mtodo que devolve o nr total de soldados Yodellers vivos.*/
	public int totalAlive(){
		int alive=0;
		for (int i=0; i<counter; i++){
			if (yodellers[i].getIsAlive())
				alive++;
		}
		return alive;
	}
	
	/** Mtodo para organizar o vector dos Yodellers pelo maior nr de soldados abatidos.*/
	public void organizeArrayMostKills() {
		for (int i=1; i<counter;i++){
			for(int j=counter-1; j>=i; j--)
				if(yodellers[j-1].getKills()<yodellers[j].getKills()) {
					Soldier tmp = yodellers[j-1];
					yodellers[j-1] = yodellers[j];
					yodellers[j] = tmp;
			     }	
		}
		for (int i = 1; i < counter; i++) {
			for (int j = counter - 1; j >= i; j--)
				if ((yodellers[j - 1].getKills() <= yodellers[j].getKills())&& (yodellers[j - 1].getExperience() < yodellers[j].getExperience())) {
					Soldier tmp = yodellers[j - 1];
					yodellers[j - 1] = yodellers[j];
					yodellers[j] = tmp;
				}
		}
	}
	
	/** Mtodo para organizar o vector dos Yodellers por ordem alfabetica.*/
	public void sortAlphabetically() {
		for(int i=1; i<counter; i++)
			for(int j=counter-1; j>=i; j--)
				if(yodellers[j-1].compareTo(yodellers[j]) > 0) {
					Soldier tmp = yodellers[j-1];
					yodellers[j-1] = yodellers[j];
					yodellers[j] = tmp;
				}
	}
	
	/** Mtodo para inicializar(limpar) o vector dos Yodellers.*/
	public void resetArray(){
		counter = 0;
		yodellers = new Soldier[MAX_SOLDIERS];
		current = -1;
	}
	
	/** Mtodo privado que devolve o ndice do vector Marcianos dado o seu nome.*/
	private int searchIndex(String name) {
		int i = 0; // percurso pelos elementos 0..counter
		int result = -1;
		boolean find = false; // indicador de existncia
		while ((i < counter) && (!find))
			if (yodellers[i].getName().equals(name))
				find = true;
			else
				i++;
		if (find)
			result = i;
		return result;
	}
}
