package marsattack;



public class Game {

	public static final String MARTIANS="marcianos";
	public static final String YODELLERS="yodellers";
	public static final String NORTH="Norte";
	public static final String SOUTH="Sul";
	public static final String EAST="Este";
	public static final String WEST="Oeste";
	public static final String CREATE_SUCCESS="Soldado adicionado com sucesso ao exercito de ";
	public static final String CREATE_NOT_SUCCESS="Soldado invlido.";
	public static final String MOVE_SUCCESS="Soldado movimentado com sucesso.";
	public static final String MOVE_NOT_SUCCESS="Erro na movimentacao do soldado.";
	public static final String MARTIANS_ATTACK_SUCCESS="Ack ack ack ack-ack! No fujam! Ns somos vossos amigos!";
	public static final String YODELLERS_ATTACK_SUCCESS="Temos de atacar agora, chefe! Aniquila! MATA! MATA! MATA! MATA!";
	public static final String KILLED_SOLDIERS=" soldados abatidos.";
	public static final String ATTACK_NOT_SUCCESS="Erro no ataque do soldado.";
	public static final String MARTIANS_VICTORY="Ack ack ack ack-ack! Calem-se de uma vez! :-)\n";
	public static final String MARTIANS_LOSS="Ack ack ack ack-ack! Estes tipos cantam TAAAAAO mal! :-(\n";
	public static final String YODELLERS_VICTORY="Primeiro, conquistaremos Marte. Depois, os IDOLOS! HURRAH! :-)\n";
	public static final String YODELLERS_LOSS="Cheira-me a esturro... :-(\n";
	public static final String RENDITION_NOT_SUCCESS="Erro na tentativa de rendicao.";
	
	//public static final String COMMAND_NOT_SUCCESS="Comando invlido.";
	
	public boolean martiansTurn;	//Indica qual o exrcito a jogar (se TRUE vez dos Marcianos; se FALSE vez dos Yodellers)
	
	YodellersArmy yodellers;
	MartiansArmy martians;
	
	public Game(){
		yodellers = new YodellersArmy();
		martians = new MartiansArmy();
		martiansTurn=true;	
	}
	public void newGame(){
		yodellers.resetArray();
		martians.resetArray();
	}
	
		
	public boolean isMartiansTurn(){
		return martiansTurn;	//Verifica se so os Marcianos a jogar
	}
	
	public void setTurn(){
		martiansTurn=!martiansTurn; //altera o exrcito a jogar
	}
		
	
	public String newSoldier(String army, String name, int coordX,int coordY, String orientation, double experience){
		String success=CREATE_NOT_SUCCESS;
		
		if (validCreateSoldier(name, orientation))
			if (army.equals(MARTIANS)){
				martians.create(name, coordX, coordY, orientation, experience);
				success=CREATE_SUCCESS+MARTIANS+".";
			}
			else if (army.equals(YODELLERS)){
				yodellers.create(name, coordX, coordY, orientation, experience);
				success=CREATE_SUCCESS+YODELLERS+".";
			}
		return success;
	}
	
		public String moveSoldier(String army, String name, String orientation, int distance){
/**		String army = in.nextLine();
		String name = in.nextLine();
		String orientation=in.nextLine();
		int distance=in.nextInt();
		in.nextLine();
	*/	int coordX=0,coordY=0;
		String success=MOVE_NOT_SUCCESS;
		
		if ((validMoveSoldier(army,name, orientation)) && (distance>=-5) && (distance<=5)){
			if (orientation.equals(NORTH)){
				coordX=0;
				coordY=distance;
			}
			else if (orientation.equals(SOUTH)){
				coordX=0;
				coordY=-distance;
			} 
			else if (orientation.equals(EAST)){
				coordX=distance;
				coordY=0;
			}
			else if (orientation.equals(WEST)){
				coordX=-distance;
				coordY=0;
			}
			if (army.equals(MARTIANS)){
				martians.move(name, orientation, coordX, coordY);
				success=MOVE_SUCCESS;
			}
			else if (army.equals(YODELLERS)){
				yodellers.move(name, orientation, coordX, coordY);
				success=MOVE_SUCCESS;
			}	
		}
		return success;
	}

		public String attackSoldier(String army, String name){
	/**		String army = in.nextLine();
			String name = in.nextLine();
		**/	String success = ATTACK_NOT_SUCCESS;
			if ((army.equals(YODELLERS))&& (yodellers.yodellerExists(name)))
				success = YODELLERS_ATTACK_SUCCESS+"\n"+ yodellers.attack(name, martians)+ KILLED_SOLDIERS;
			else if ((army.equals(MARTIANS)) && (martians.martianExists(name)))
				success = MARTIANS_ATTACK_SUCCESS+"\n"+ martians.attack(name, yodellers)+ KILLED_SOLDIERS;			
			return success;
		}
		
		public String rendition(String army){
			String rendition=RENDITION_NOT_SUCCESS;
			if (army.equals(MARTIANS)){
				rendition= YODELLERS_LOSS+MARTIANS_VICTORY;
			}
			else if (army.equals(YODELLERS)){
				rendition= MARTIANS_LOSS+YODELLERS_VICTORY;
			}
			return rendition;
		}
		
		public int isArmyDead(){
			int terminated=0;				//Nenhum dos exrcitos foi aniquilado, CONTINUA O JOGO
			if (yodellers.totalAlive()==0)	//Nenhum soldado Yodeller vivo
				terminated=1;				//Vitria dos Marcianos
			else if (martians.totalAlive()==0) //Nenhum soldado Marciano vivo
				terminated=2;					//Vitria dos Yodellers
			return terminated;
		}
				
/**		public void listBattleField(){
			yodellers.initializeIterator();
			while (yodellers.hasNext()) {
				System.out.println(yodellers.next().toString());
			}
			martians.initializeIterator();
			while (martians.hasNext()) {
				System.out.println(martians.next().toString());
			}
		}
**/		
		
		private boolean validCreateSoldier (String name, String orientation){
			boolean valid=false;
			if ((!yodellers.yodellerExists(name)) && (!martians.martianExists(name)))
				if ((orientation.equals(NORTH)) || (orientation.equals(SOUTH)) || (orientation.equals(EAST) || (orientation.equals(WEST))))
					valid=true;
			return (valid);
		}

		private boolean validMoveSoldier (String army, String name, String orientation){
			boolean valid=false;			
			if ((orientation.equals(NORTH)) || (orientation.equals(SOUTH)) || (orientation.equals(EAST) || (orientation.equals(WEST)))){
				if ((army.equals(YODELLERS))&& (yodellers.yodellerExists(name)))
					valid=true;
				else if ((army.equals(MARTIANS)) && (martians.martianExists(name)))
					valid=true;
			}
			return (valid);
		}
		
	
}