package marsattack;

import java.util.Scanner;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Locale;


/**
* @author Ricardo Gaspar, n 35277, Turno TP6
* @author Ricardo Cruz, n 34951, Turno TP6
*
* Docente: Miguel Monteiro
*/

public class Main {

	public static final String MARTIANS="marcianos";
	public static final String YODELLERS="yodellers";
	public static final String NOVO_JOGO = "NJ";
	public static final String CARREGA_JOGO = "CJ";
	public static final String GRAVA_JOGO = "GJ";
	public static final String CRIA_SOLDADO = "CS";
	public static final String INICIA_BATALHA = "IB";
	public static final String MOVE_SOLDADO = "MS";
	public static final String ATACA = "AT";
	public static final String RENDIO = "RE";
	public static final String LISTA_CAMPO_DE_BATALHA = "LCDB";
	public static final String LISTA_MORTOS = "LM";
	public static final String LISTA_HEROIS = "LH";
	public static final String AJUDA = "A";
	public static final String TERMINA_JOGO = "S";
	public static final String COMANDO_INVALIDO="Comando invlido.";
	public static final String CREATE_SUCCESS="Soldado adicionado com sucesso ao exrcito de ";
	public static final String CREATE_NOT_SUCCESS="Soldado invlido.";
	public static final String MOVE_SUCCESS="Soldado movimentado com sucesso.";
	public static final String EMPTY_ARMY="Exrcito vazio.";
	public static final String MARTIANS_ATTACK_SUCCESS="Ack ack ack ack-ack! No fujam! Ns somos vossos amigos!";
	public static final String YODELLERS_ATTACK_SUCCESS="Temos de atacar agora, chefe! Aniquila! MATA! MATA! MATA! MATA!";
	public static final String MARTIANS_VICTORY="Ack ack ack ack-ack! Calem-se de uma vez! :-)\n";
	public static final String MARTIANS_LOSS="Ack ack ack ack-ack! Estes tipos cantam TAAAAAO mal! :-(\n";
	public static final String YODELLERS_VICTORY="Primeiro, conquistaremos Marte. Depois, os IDOLOS! HURRAH! :-)\n";
	public static final String YODELLERS_LOSS="Cheira-me a esturro... :-(\n";
	public static final String RENDITION_NOT_SUCCESS="Erro na tentativa de rendio.";
	public static final String MOVE_NOT_SUCCESS="Erro na movimentacao do soldado.";
	public static final String ATTACK_NOT_SUCCESS="Erro no ataque do soldado.";
	
	public static final int FASE_0 = 0;
	public static final int FASE_1 = 1;
	public static final int FASE_2 = 2;
	public static final int FASE_3 = 3;
	
	public static final int MAX=500;	//Este valor serve para no duplicar o vector, pois
									    //se o desejsse-mos faz- teramos de implementar um metodo para verificar se expandia o vector a cada instruo lineIndex[++]
	
	private static int fase;
	private static String[] lines; //vector de strings para guardar os comandos vlidos
	private static int lineIndex;	
	private static int countOperations;

	public static void main(String[] args) throws Exception {
		lineIndex = 0;
		countOperations=0;
		lines = new String[MAX];
		
		Scanner in = new Scanner(System.in);
    	in.useLocale(Locale.US);
		Game game= new Game();
		String cmd;

		fase = FASE_0;

		boolean notQuit = true;
		while (notQuit) {
			cmd = getCommand(in);
			if (cmd.equals(NOVO_JOGO)) {
				newGame(game);
				continue;
			} 
			else if (cmd.equals(TERMINA_JOGO)) {
				System.out.println("At breve!");
				return;
			} 
			else if (cmd.equals(AJUDA)) {
				help();
				continue;
			}
			switch (fase) {
			case FASE_0:
				System.out.println(COMANDO_INVALIDO);
				break;
				
			case FASE_1:
				if(cmd.equals(INICIA_BATALHA))
					initBattle(game);
				else if(cmd.equals(CRIA_SOLDADO))
					createSoldier(in, game);
				else if (cmd.equals(GRAVA_JOGO))
					saveGame(in);
				else if (cmd.equals(CARREGA_JOGO))
					readGame(in, game);
				else if (cmd.equals(LISTA_CAMPO_DE_BATALHA))
					listBattleField(game);
				else if (cmd.equals(LISTA_HEROIS))
					listHeroes(game);
				else if (cmd.equals(LISTA_MORTOS))
					listDead(game);
				else System.out.println(COMANDO_INVALIDO);
				break;
			
case FASE_2: 
				if(cmd.equals(MOVE_SOLDADO))
					moveSoldier(in,game);
				else if(cmd.equals(ATACA))
					attackSoldier(in, game);
				else if (cmd.equals(GRAVA_JOGO))
					saveGame(in);
				else if (cmd.equals(CARREGA_JOGO))
					readGame(in, game);
		  		else if (cmd.equals(RENDIO))
					rendition(in,game);
				else if (cmd.equals(LISTA_CAMPO_DE_BATALHA))
					listBattleField(game);
				else if (cmd.equals(LISTA_HEROIS))
					listHeroes(game);
				else if (cmd.equals(LISTA_MORTOS))
					listDead(game);
				else System.out.println(COMANDO_INVALIDO);
				break; 
				
			case FASE_3:
		 		if (cmd.equals(GRAVA_JOGO))
					saveGame(in);
				else if (cmd.equals(CARREGA_JOGO))
					readGame(in, game);
				else if (cmd.equals(LISTA_CAMPO_DE_BATALHA))
					listBattleField(game);
				else if (cmd.equals(LISTA_HEROIS))
					listHeroes(game);
				else if (cmd.equals(LISTA_MORTOS))
					listDead(game);
				else System.out.println(COMANDO_INVALIDO);
				break; 
			}
			
				
		}



		}
	

	private static String getCommand(Scanner in) {
		String input = "";
		System.out.print("> ");
		input = in.nextLine().toUpperCase();
		return input;
	}
	
	private static void newGameFile(Game game) {
		game.newGame();
		lineIndex = 0;
		fase = FASE_1;
	}
	

	private static void newGame(Game game) {
		game.newGame();
		lineIndex = 0;
		fase = FASE_1;
		System.out.println("Jogo iniciado.");
	}

	private static void help() {
		System.out.println("Marte Ataca! Viemos em paz! Precisa de ajuda?\n"+"NJ  Novo Jogo\n"
				+"CJ  Carrega Jogo\n"+"GJ  Grava Jogo\n"+"CS  Cria Soldado\n"
				+"IB  Inicia Batalha\n"+"MS  Move Soldado\n"+"AT  ATaca\n"+"RE - REndicao\n"
				+"LCDB  Lista Campo De Batalha\n"+"LM  Lista Mortos\n"+"LH  Lista Hrois\n"
				+"A - Ajuda\n"+"S  Termina Jogo\n");
	}
	
	private static void initBattleFile(Game game) {
			fase = FASE_2;
			lineIndex++;
	}
	
	private static void initBattle(Game game) {
		
		if ((game.yodellers.totalAlive()>0) && (game.martians.totalAlive()>0)){
			fase = FASE_2;
			System.out.println("Ack ack ack ack-ack! Viemos em Paz!");
			lines[lineIndex] = INICIA_BATALHA;
			lineIndex++;
			countOperations++;
		}
		else System.out.println("Erro na inicializao da batalha.");
	}
	
	private static void createSoldierFile(Scanner fin, Game game){
		String army = fin.next();
		String name = fin.next();
		int coordX = fin.nextInt();
		int coordY = fin.nextInt();
		String orientation=fin.next();
		double experience = fin.nextDouble();
	    
		game.newSoldier(army, name, coordX, coordY, orientation, experience);
		lines[lineIndex] = CRIA_SOLDADO;
		lineIndex++;
		lines[lineIndex] = army;
		lineIndex++;
		lines[lineIndex] = name;
		lineIndex++;
		lines[lineIndex] = coordX+"";
		lineIndex++;
		lines[lineIndex] = coordY+"";
		lineIndex++;
		lines[lineIndex] = orientation;
		lineIndex++;
		lines[lineIndex] = experience+ "";
		lineIndex++;
	}
	
	private static void createSoldier(Scanner in, Game game) {
		String army = in.nextLine();
		String name = in.nextLine();
		int coordX = in.nextInt();
		int coordY = in.nextInt();
		in.nextLine();
		String orientation=in.next();
		double experience = in.nextDouble();
		in.nextLine();
	    String valid= CREATE_NOT_SUCCESS;
	    valid = game.newSoldier(army, name, coordX, coordY, orientation, experience);
		
		System.out.println(valid);
		
		if (!valid.equals(CREATE_NOT_SUCCESS)){
			lines[lineIndex] = CRIA_SOLDADO;
			lineIndex++;
			lines[lineIndex] = army;
			lineIndex++;
			lines[lineIndex] = name;
			lineIndex++;
			lines[lineIndex] = coordX+"";
			lineIndex++;
			lines[lineIndex] = coordY+"";
			lineIndex++;
			lines[lineIndex] = orientation;
			lineIndex++;
			lines[lineIndex] = experience+ "";
			lineIndex++;
			countOperations++;
		}
	}

	private static void moveSoldierFile(Scanner fin, Game game) {
		String army = fin.next(); 
		String name = fin.next();
		String orientation=fin.next();
		int distance=fin.nextInt();
	    
		game.moveSoldier(army, name, orientation, distance);
		lines[lineIndex] = MOVE_SOLDADO;
		lineIndex++;
		lines[lineIndex] = army;
		lineIndex++;
		lines[lineIndex] = name;
		lineIndex++;
		lines[lineIndex] = orientation;
		lineIndex++;
		lines[lineIndex] = distance+ "";
		lineIndex++;
	    	
	}
	
	
	private static void moveSoldier(Scanner in, Game game) {
		String army = in.nextLine(); 
		String name = in.nextLine();
		String orientation=in.nextLine();
		int distance=in.nextInt();
		in.nextLine();
		
	    String valid= MOVE_NOT_SUCCESS;
	    
	    if ( ( (game.isMartiansTurn()) && (army.equals(MARTIANS))) || ( (!game.isMartiansTurn()) && (army.equals(YODELLERS)) ) )
	    	valid = game.moveSoldier(army, name, orientation, distance);
	    	
		System.out.println(valid); 
		
		if (valid.equals(MOVE_SUCCESS)){
			game.setTurn();
			lines[lineIndex] = MOVE_SOLDADO;
			lineIndex++;
			lines[lineIndex] = army;
			lineIndex++;
			lines[lineIndex] = name;
			lineIndex++;
			lines[lineIndex] = orientation;
			lineIndex++;
			lines[lineIndex] = distance+ "";
			lineIndex++;
			countOperations++;
		}
	}
	
	private static void attackSoldierFile(Scanner fin, Game game) {
		String army = fin.next(); 
		String name = fin.next();
	   
	    game.attackSoldier(army, name);
		
		if(game.isArmyDead()==1){
			fase=FASE_3;
		}
		else if (game.isArmyDead()==2){
			fase=FASE_3;
		}
		lines[lineIndex] = ATACA;
		lineIndex++;
		lines[lineIndex] = army;
		lineIndex++;
		lines[lineIndex] = name;
		lineIndex++;
	}
	
	
	private static void attackSoldier(Scanner in, Game game) {
		String army = in.nextLine(); 
		String name = in.nextLine();
	    String valid= ATTACK_NOT_SUCCESS;
	    if ( ( (game.isMartiansTurn()) && (army.equals(MARTIANS))) || ( (!game.isMartiansTurn()) && (army.equals(YODELLERS)) ) )
	    	valid = game.attackSoldier(army, name);
		System.out.println(valid); 
		
		if (!(valid.equals(ATTACK_NOT_SUCCESS))){
			game.setTurn();
			lines[lineIndex] = ATACA;
			lineIndex++;
			lines[lineIndex] = army;
			lineIndex++;
			lines[lineIndex] = name;
			lineIndex++;
			countOperations++;
		}
		if(game.isArmyDead()==1){
			System.out.print(MARTIANS_VICTORY + YODELLERS_LOSS);
			fase=FASE_3;
		}
		else if (game.isArmyDead()==2){
			System.out.print(YODELLERS_VICTORY + MARTIANS_LOSS);
			fase=FASE_3;
		}
	}
	
	private static void renditionFile(Scanner fin, Game game){
		String army=fin.next();
	    	game.rendition(army);
			fase=FASE_3;
			lines[lineIndex] = RENDIO;
			lineIndex++;
			lines[lineIndex] = army;
			lineIndex++;
	}
	
	private static void rendition(Scanner in, Game game){
		String army=in.nextLine();
		String valid=RENDITION_NOT_SUCCESS;
		
		if ( ( (game.isMartiansTurn()) && (army.equals(MARTIANS))) || ( (!game.isMartiansTurn()) && (army.equals(YODELLERS)) ) ){
	    	valid = game.rendition(army);
			fase=FASE_3;
		}	
		System.out.println(valid);
		
		if (!(valid.equals(RENDITION_NOT_SUCCESS))){
			game.setTurn();
			lines[lineIndex] = RENDIO;
			lineIndex++;
			lines[lineIndex] = army;
			lineIndex++;
			countOperations++;
		}
	}

	private static void readGame(Scanner in,Game game)throws Exception {
		newGameFile(game);
		String file=in.nextLine();
		FileReader fich = new FileReader(file);
		Scanner fin = new Scanner(fich);
		fin.useLocale(Locale.US);
        countOperations= fin.nextInt();
		fin.nextLine();
		for(int i=0; i<countOperations; i++){
			String cmd=fin.next();
			if(cmd.equals(CRIA_SOLDADO))
				createSoldierFile(fin, game);
			else if (cmd.equals(INICIA_BATALHA))
				initBattleFile(game);
			else if(cmd.equals(MOVE_SOLDADO))
				moveSoldierFile(fin,game);
			else if(cmd.equals(ATACA))
				attackSoldierFile(fin, game);
			else if (cmd.equals(RENDIO))
				renditionFile(fin,game);
		}
		System.out.println("Jogo carregado.");
		fin.close();	
	}
	
	private static void saveGame(Scanner in)throws Exception{
		String file=in.nextLine();
		PrintWriter pw= new PrintWriter(file);
		pw.println(countOperations);
		for(int i=0; i<lineIndex; i++){
		pw.print(lines[i]+"\n");
		}
		pw.close();
	}
		
	
	
	private static void listBattleField(Game game){
		game.yodellers.sortAlphabetically();
		System.out.println(YODELLERS);
		game.yodellers.initializeIterator();
		int countYodellersAlive=0;
		while (game.yodellers.hasNext()) {
			Soldier temp = game.yodellers.next();
			if (temp.getIsAlive()){
				System.out.print(temp.toString());
				countYodellersAlive++;
			}
		}
		if (countYodellersAlive==0)
			System.out.println(EMPTY_ARMY);
		
		game.martians.sortAlphabetically();
		System.out.println(MARTIANS);
		game.martians.initializeIterator();
		int countMartiansAlive=0;
		while (game.martians.hasNext()) {
			Soldier temp = game.martians.next();
			if (temp.getIsAlive()){
				System.out.print(temp.toString());
				countMartiansAlive++;
			}
		}
		if (countMartiansAlive==0)
			System.out.println(EMPTY_ARMY);
	}

	private static void listHeroes(Game game){
		game.yodellers.organizeArrayMostKills();
		game.yodellers.initializeIterator();
		
		System.out.println(YODELLERS);
		if (game.yodellers.hasNext()){	
			Soldier temp = game.yodellers.next();
			System.out.println(temp.getName()+";"+temp.getKills());
		}
		else System.out.println(EMPTY_ARMY);
		
		System.out.println(MARTIANS);
		game.martians.organizeArrayMostKills();
		game.martians.initializeIterator();
		if (game.martians.hasNext()){	
			Soldier temp = game.martians.next();
			System.out.println(temp.getName()+";"+temp.getKills());
		}
		else System.out.println(EMPTY_ARMY);
	}
	
	private static void listDead(Game game){
		game.yodellers.sortAlphabetically();
		game.yodellers.initializeIterator();
		System.out.println(YODELLERS);
		int countDeadYodellers=0;
		while (game.yodellers.hasNext()) {
			Soldier temp = game.yodellers.next();
			if (!temp.getIsAlive()){
				System.out.println(temp.getName()+";"+temp.getKills());
				countDeadYodellers++;
			}
		}
		if (countDeadYodellers==0)
			System.out.println("OK");
				
		System.out.println(MARTIANS);
		game.martians.organizeArrayMostKills();
		game.martians.initializeIterator();
		int countDeadMartians=0;
		while (game.martians.hasNext()) {
			Soldier temp = game.martians.next();
			if (!temp.getIsAlive()){
				System.out.println(temp.getName()+";"+temp.getKills());
				countDeadMartians++;
			}
		}
		if (countDeadMartians==0)
			System.out.println("OK");
	}
		
}
