package marsattack;

public class MartiansArmy {
	public static final int MAX_SOLDIERS = 50;

	private Soldier[] martians; // vector do exrcito dos marcianos

	private int counter; // nmero de soldados Marciano no vector
	private int current; // posio do soldado Marciano corrente

	public MartiansArmy() {
		counter = 0;
		martians = new Soldier[MAX_SOLDIERS];
		current = -1;
	}
	
	/** Iterador que inicializa a travessia do vector.*/
	public void initializeIterator() {
		if (counter > 0)
			current = 0;
		else
			current = -1;
	}
	
	/** Iterador que verifica a existncia de um prximo soldado Marciano no vector.*/
	public boolean hasNext() {
		return ((current >= 0) && (current < counter));
	}
	
	/** Iterador que devolve o soldado corrente do vector*/
	public Soldier next() {
		Soldier martian = null;
		if (this.hasNext())
			martian = martians[current++];
		return martian;
	}
	
	/** Mtodo para criar um soldado Marciano.*/
	public void create(String name, int coordX, int coordY,
			String orientation, double experience) {
		boolean isAlive = true;
		if (searchIndex(name) == -1) { // novo soldado Yodeller
			if (counter == martians.length) { // vector cheio
				Soldier tmp[] = new Soldier[2 * martians.length];
				int i = 0;
				while (i < counter) {
					tmp[i] = martians[i];
					i++;
				}
				martians = tmp;
			}
			martians[counter] = new Soldier(name, coordX, coordY,
					orientation, experience,isAlive);
			counter++;
		}
	}
	
	/** Mtodo para realizar um movimento.*/
	public int move(String name, String orientation, int coordX, int coordY) {
		int index = searchIndex(name);
		if (index != -1) { // yodeller existente
			martians[index].setMove(orientation, coordX, coordY); // altera a
																	// posio
		}
		return index;
	}
	
	/** Mtodo para realizar um ataque.*/
	public int attack(String name, YodellersArmy yodellers){
		
		int index=searchIndex(name),x,y,tempKills=0;
		String o;
		double radius;
		
		if ((index!=-1) && (martians[index].getIsAlive())){	//Se o nome introduzido for vlido e se o yodeller em questo estiver vivo
			x=martians[index].getCoordX();
			y=martians[index].getCoordY();
			o=martians[index].getOrientation();
			radius=martians[index].getExperience();
			
			tempKills=yodellers.attacked(x,y,o,radius);

			martians[index].setKills(tempKills);
			martians[index].setExperience(tempKills*0.05*martians[index].getExperience());
			
		}
		organizeArrayMostKills();
		return tempKills;
	}
	
	/** Mtodo para registar quais os soldados afectados pelo ataque do inimigo.*/
	public int attacked(int xYodeller, int yYodeller, double rangeYodeller) {
		int killed = 0;
		// initializeIteratorMartian();
		for (int i = 0; i < counter; i++) {
			int xMartian = martians[i].getCoordX();
			int yMartian = martians[i].getCoordY();
			double rangeMartian = Math.sqrt(Math.pow(xMartian - xYodeller, 2)
					+ Math.pow(yMartian - yYodeller, 2));
			if (martians[i].getIsAlive() && (rangeMartian <= rangeYodeller)) {
				martians[i].setIsAlive(false);
				killed++;
			}
		}

		return killed;
	}

	/** Mtodo para verificar a existncia de um soldado dado o seu nome.*/
	public boolean martianExists(String name)
	{
		return (searchIndex(name)!=-1);
	}
	
	/** Mtodo que devolve o nr total de soldados Marcianos vivos.*/
	public int totalAlive(){
		int alive=0;
		for (int i=0; i<counter; i++){
			if (martians[i].getIsAlive())
				alive++;
		}
		return alive;
	}
	
	/** Mtodo para organizar o vector dos Marcianos por ordem alfabetica.*/
	public void sortAlphabetically() {
		for(int i=1; i<counter; i++)
			for(int j=counter-1; j>=i; j--)
				if(martians[j-1].compareTo(martians[j]) > 0) {
					Soldier tmp = martians[j-1];
					martians[j-1] = martians[j];
					martians[j] = tmp;
				}
	}
	
	/** Mtodo para organizar o vector dos Marcianos pelo maior nr de soldados abatidos.*/
	public void organizeArrayMostKills() {
		for (int i=1; i<counter;i++){
			for(int j=counter-1; j>=i; j--)
			if(martians[j-1].getKills()<martians[j].getKills()) {
			Soldier tmp = martians[j-1];
			martians[j-1] = martians[j];
			martians[j] = tmp;
			     }	
		}
		for (int i = 1; i < counter; i++) {
			for (int j = counter - 1; j >= i; j--)
				if ((martians[j - 1].getKills() <= martians[j].getKills())&& (martians[j - 1].getExperience() < martians[j].getExperience())) {
					Soldier tmp = martians[j - 1];
					martians[j - 1] = martians[j];
					martians[j] = tmp;
				}
		}
	}
	/** Mtodo para inicializar(limpar) o vector dos Marcianos.*/
	public void resetArray(){
		counter = 0;
		martians = new Soldier[MAX_SOLDIERS];
		current = -1;
	}
	
	/** Mtodo privado que devolve o ndice do vector Marcianos dado o seu nome.*/
	private int searchIndex(String name) {
		int i = 0; // percurso pelos elementos 0..counter
		int result = -1;
		boolean find = false; // indicador de existncia
		while ((i < counter) && (!find))
			if (martians[i].getName().equals(name))
				find = true;
			else
				i++;
		if (find)
			result = i;
		return result;
	}
}
