package marsattack;

public class Soldier {

	private String name;
	private int coordX;
	private int coordY;
	private String orientation;
	private double experience;
	private int kills; // Nmero de inimigos abatidos.
    private boolean isAlive;
	
	public Soldier(String name, int coordX, int coordY, String orientation,
			double experience, boolean isAlive) {
		this.name = name;
		this.coordX = coordX;
		this.coordY = coordY;
		this.orientation = orientation;
		this.experience = experience;
		this.kills = 0;
		this.isAlive = isAlive;
	}

	/** Mtodo para consultar o nome de um soldado*/
	public String getName() {
		return this.name;
	}

	/** Mtodo para consultar a coordenada X de um soldado*/
	public int getCoordX() {
		return this.coordX;
	}
	/** Mtodo para consultar a coordenada Y de um soldado*/
	public int getCoordY() {
		return this.coordY;
	}

	/** Mtodo para consultar a orientao de um soldado*/
	public String getOrientation() {
		return this.orientation;
	}

	/** Mtodo para consultar a percia de um soldado*/
	public double getExperience() {
		return this.experience;
	}
	
	/** Mtodo para conultar o nr de soldados abatidos por um soldado*/
	public int getKills() {
		return this.kills;
	}
	
	/** Mtodo para consultar o estado de vida de um soldado*/
	public boolean getIsAlive(){
	    return this.isAlive;
	}
	 
	/** Mtodo para definir a nova posio de um soldado*/
	public void setMove(String orientation,int coordX,int coordY){
		this.coordX+=coordX;
		this.coordY+=coordY;
		this.orientation=orientation;
	}
	
	/** Mtodo para definir a percia de um soldado*/
	public void setExperience(double experience){
		this.experience+=experience;
	}
	
	/** Mtodo para definir o nr de soldados abatidos*/
	public void setKills(int kills){
		this.kills+=kills;
	}
	
	/** Mtodo para alterar o estado de vida do soldado*/
	public void setIsAlive(boolean isAlive){
		this.isAlive=isAlive;
	}
	
	/** Mtodo para devolver os dados do soldado para uma string.*/
	public String toString() {
		return (this.name + ";" + this.coordX + ";" + this.coordY + ";" 
				+ this.orientation + ";" + this.experience + ";" + this.kills + "\n");
	}
	
	/** Mtodo para comparar as strings do nome de um soldado*/
	public int compareTo(Soldier sold) {
		return name.compareTo(sold.getName());
		}
}