/**
 * 
 */
package cloud;

/**
 * @author 53298
 *
 */
public interface Accounts {

	static final int CAPACITY_FILES = 100;

	/**
	 * gets account mail
	 * 
	 * @return mail
	 */
	String getMail();

	/**
	 * gets account type
	 * 
	 * @return type
	 */
	String getType();

	/**
	 * gets account memory
	 * 
	 * @return memory
	 */
	int getMemory();

	/**
	 * adds file to an account
	 * 
	 * @param file
	 * @param size
	 */
	void addFile(String file, int size);

	/**
	 * gets a file size
	 * 
	 * @param index
	 * @return file size
	 */
	int getFileSize(int index);

	/**
	 * shares a file
	 * 
	 * @param file
	 * @param name
	 * @param owner
	 * @param size
	 */
	void shareFile(String file, String name, String owner, int size);

	/**
	 * checks if a file is shared
	 * 
	 * @param name
	 * @return true/false
	 */
	boolean sharedFile(String name);

	/**
	 * searches file by name
	 * 
	 * @param name
	 * @return position
	 */
	int searchByName(String name);

	/**
	 * searches file by name
	 * 
	 * @param name
	 * @return position
	 */
	int searchByNameShare(String file, String owner);

	/**
	 * initialises files iterator
	 */
	void initialiseFilesIterator();

	/**
	 * checks if there are more files in the array
	 * 
	 * @return true/false
	 */
	boolean hasNextFile();

	/**
	 * gets next file in the array
	 * 
	 * @return file
	 */
	Files nextFile();
}