/**
 * 
 */
package cloud;

/**
 * @author 53298
 *
 */
public class CloudClass implements Cloud {

	private int counter;

	Accounts[] accounts;
	Iterator iterator;

	public CloudClass() {
		accounts = new AccountsBasicClass[CAPATICY_ACCOUNTS];
		counter = 0;
	}

	@Override
	public boolean addAccount(String mail, String type) {
		boolean result = false;
		if (searchByMail(mail) == -1) {
			if (type.equals("basic"))
				accounts[counter++] = new AccountsBasicClass(mail);
			else
				accounts[counter++] = new AccountsPremiumClass(mail);
			result = true;
		}
		return result;
	}

	@Override
	public int uploadFile(String mail, String file, int size) {
		int result = 0;
		if (searchByMail(mail) == -1)
			result = 1;
		else if (accounts[searchByMail(mail)].searchByName(file) != -1)
			result = 2;
		else if (accounts[searchByMail(mail)].getMemory() - size < 0)
			result = 3;
		else
			accounts[searchByMail(mail)].addFile(file, size);
		return result;
	}

	@Override
	public int fileShare(String mail1, String mail2, String file) {
		int pos1 = searchByMail(mail1);
		int pos2 = searchByMail(mail2);
		int result = 0;
		if (pos1 == -1 || pos2 == -1)
			result = 1;
		else if (accounts[pos1].searchByName(file) == -1)
			result = 2;
		else if (accounts[pos1].getType().equals(TYPE_BASIC))
			result = 3;
		else if (accounts[pos2].searchByNameShare(file, mail1) != -1)
			result = 4;
		else if (accounts[pos2].getType().equals(TYPE_BASIC)
				&& accounts[pos2].getMemory() - (accounts[pos1].getFileSize(accounts[pos1].searchByName(file)) / 2) < 0)
			result = 5;
		else {
			int size = accounts[pos1].getFileSize(accounts[pos1].searchByName(file));
			// accounts[pos1].addFile(file, size);
			accounts[pos1].shareFile(file, mail1, mail1, size);
			// accounts[pos2].addFile(file, size);
			accounts[pos2].shareFile(file, mail2, mail1, size);
		}
		return result;
	}

	/*@Override
	public int fileUpdate(String mail1, String mail2, String file) {
		int result = 0;
		int pos1 = searchByMail(mail1);
		int pos2 = searchByMail(mail2);
		if (pos1 == -1 || pos2 == -1)
			result = 1;
		else if (accounts[pos1].searchByName(file) == -1)
			result = 2;
		else if (accounts[pos2].searchByNameShare(file, mail1) == -1)
			result = 3;
		else {
			lastUpdate = mail2;
		}
		return result;
	}*/

	@Override
	public int searchByMail(String mail) {
		int finalpos = -1;
		int pos = 0;
		while (finalpos == -1 && pos < counter) {
			if (accounts[pos].getMail().equals(mail))
				finalpos = pos;
			else
				pos++;
		}
		return finalpos;
	}

	@Override
	public void initialiseAccountsIterator() {
		iterator = new IteratorClass(accounts, counter);
	}

	@Override
	public boolean hasNextAccount() {
		return iterator.hasNext();
	}

	@Override
	public Accounts nextAccount() {
		return iterator.nextAccount();
	}

	@Override
	public void initialiseFilesIterator(String mail) {
		accounts[searchByMail(mail)].initialiseFilesIterator();
	}

	@Override
	public boolean hasNextFile(String mail) {
		return accounts[searchByMail(mail)].hasNextFile();
	}

	@Override
	public Files nextFile(String mail) {
		return accounts[searchByMail(mail)].nextFile();
	}
}