import java.util.Scanner;

import cloud.*;

/**
 * 
 */

/**
 * @author 53298
 *
 */
public class Main {

	/**
	 * constants for commands
	 */
	private static final String ADD = "ADD";
	private static final String UPLOAD = "UPLOAD";
	private static final String SHARE = "SHARE";
	private static final String MINSPACE = "MINSPACE";
	private static final String LISTFILES = "LISTFILES";
	private static final String LISTALL = "LISTALL";
	/*private static final String UPDATE = "UPDATE";
	private static final String LASTUPDATE = "LASTUPDATE";*/
	private static final String EXIT = "EXIT";

	/**
	 * constants for messages
	 */
	private static final String MSG_ACCOUNT_NONE = "No accounts.";
	private static final String MSG_ACCOUNT_LIST = "All accounts:";
	private static final String MSG_ACCOUNT_ADDED = "Account was added.";
	private static final String MSG_ACCOUNT_EXISTS = "Account already exists.";
	private static final String MSG_ACCOUNT_NOT_EXISTS = "Account does not exist.";
	private static final String MSG_ACCOUNT_MINSPACE = "Account with least free space: ";
	private static final String MSG_FILE_UPLOADED = "File uploaded into account.";
	private static final String MSG_FILE_EXISTS = "File already exists in the account.";
	private static final String MSG_FILE_NOT_EXISTS = "File does not exist.";
	private static final String MSG_FILE_SIZE = "File size exceeds account capacity.";
	private static final String MSG_FILE_SHARED = "File was shared.";
	private static final String MSG_FILE_NOT_SHARED = "Account does not allow file sharing.";
	private static final String MSG_FILE_ALREADY_SHARED = "File already shared.";
	private static final String MSG_FILE_LIST = "Account files:";
	/*private static final String MSG_FILE_IS_NOT_SHARED = "File not shared.";
	private static final String MSG_FILE_UPDATED = "File was updated.";*/
	private static final String MSG_EXIT = "Exiting...";

	public static void main(String[] args) {
		Scanner in = new Scanner(System.in);
		Cloud cloud = new CloudClass();
		String option = "";
		while (!option.equals(EXIT)) {
			option = in.next().toUpperCase();
			switch (option) {
			case (ADD):
				addAccount(in, cloud);
				System.out.println("");
				break;
			case (UPLOAD):
				uploadFile(in, cloud);
				System.out.println("");
				break;
			case (SHARE):
				fileShare(in, cloud);
				System.out.println("");
				break;
			case (MINSPACE):
				minSpace(in, cloud);
				System.out.println("");
				break;
			case (LISTFILES):
				listAccountFiles(in, cloud);
				System.out.println("");
				break;
			case (LISTALL):
				listAll(in, cloud);
				System.out.println("");
				break;
			/*case (UPDATE):
				updateFile(in, cloud);
				break;
			case (LASTUPDATE):
				lastFileUpdate(in, cloud);
				break;*/
			default:
				break;
			}
		}
		System.out.println(MSG_EXIT);
		System.out.println("");
		in.close();
	}

	private static void addAccount(Scanner in, Cloud cloud) {
		String mail = in.next();
		String type = in.next();
		in.nextLine();
		if (!cloud.addAccount(mail, type))
			System.out.println(MSG_ACCOUNT_EXISTS);
		else
			System.out.println(MSG_ACCOUNT_ADDED);
	}

	private static void uploadFile(Scanner in, Cloud cloud) {
		String mail = in.next();
		String file = in.next();
		int size = in.nextInt();
		in.nextLine();
		int error = cloud.uploadFile(mail, file, size);
		if (error == 1)
			System.out.println(MSG_ACCOUNT_NOT_EXISTS);
		else if (error == 2)
			System.out.println(MSG_FILE_EXISTS);
		else if (error == 3)
			System.out.println(MSG_FILE_SIZE);
		else
			System.out.println(MSG_FILE_UPLOADED);
	}

	private static void fileShare(Scanner in, Cloud cloud) {
		String mail1 = in.next();
		String mail2 = in.next();
		String file = in.next();
		in.nextLine();
		int error = cloud.fileShare(mail1, mail2, file);
		if (error == 1)
			System.out.println(MSG_ACCOUNT_NOT_EXISTS);
		else if (error == 2)
			System.out.println(MSG_FILE_NOT_EXISTS);
		else if (error == 3)
			System.out.println(MSG_FILE_NOT_SHARED);
		else if (error == 4)
			System.out.println(MSG_FILE_ALREADY_SHARED);
		else if (error == 5)
			System.out.println(MSG_FILE_SIZE);
		else
			System.out.println(MSG_FILE_SHARED);
	}

	private static void minSpace(Scanner in, Cloud cloud) {
		in.nextLine();
		cloud.initialiseAccountsIterator();
		Accounts account;
		if (!cloud.hasNextAccount())
			System.out.println(MSG_ACCOUNT_NONE);
		else {
			int memory = 5120;
			String mail = "";
			while (cloud.hasNextAccount()) {
				account = cloud.nextAccount();
				if (account.getMemory() < memory) {
					memory = account.getMemory();
					mail = account.getMail();
				}
			}
			System.out.println(MSG_ACCOUNT_MINSPACE + mail);
		}
	}

	private static void listAccountFiles(Scanner in, Cloud cloud) {
		String mail = in.next();
		in.nextLine();
		if (cloud.searchByMail(mail) == -1)
			System.out.println(MSG_ACCOUNT_NOT_EXISTS);
		else {
			cloud.initialiseFilesIterator(mail);
			System.out.println(MSG_FILE_LIST);
			Files file;
			while (cloud.hasNextFile(mail)) {
				file = cloud.nextFile(mail);
				if (!file.shared())
					System.out.println(file.getName() + " (" + file.getSize() + " MB)");
				else
					System.out.println(file.getName() + " (" + file.getSize() + " MB) (shared)");
			}
		}
	}

	private static void listAll(Scanner in, Cloud cloud) {
		in.nextLine();
		System.out.println(MSG_ACCOUNT_LIST);
		cloud.initialiseAccountsIterator();
		Accounts account;
		while (cloud.hasNextAccount()) {
			account = cloud.nextAccount();
			System.out.println(account.getMail() + " (" + account.getType() + ")");
		}
	}

	/*private static void updateFile(Scanner in, Cloud cloud) {
		String mail1 = in.next();
		String mail2 = in.next();
		String file = in.next();
		in.nextLine();
		int error = cloud.fileUpdate(mail1, mail2, file);
		if (error == 1)
			System.out.println(MSG_ACCOUNT_NOT_EXISTS);
		else if (error == 2)
			System.out.println(MSG_FILE_NOT_EXISTS);
		else if (error == 3)
			System.out.println(MSG_FILE_IS_NOT_SHARED);
		else
			System.out.println(MSG_FILE_UPDATED);
	}
	
	private static void lastFileUpdate(Scanner in, Cloud cloud) {
		
	}*/
}