/**
 * 
 */
package cloud;

/**
 * @author 53298
 *
 */
public class AccountsBasicClass implements Accounts {

	Files[] files;
	Iterator iterator;

	static final String TYPE = "Basic";
	private String mail;
	protected int memory, counter;

	public AccountsBasicClass(String mail) {
		files = new FilesClass[CAPACITY_FILES];
		this.mail = mail;
		memory = 2048;
	}

	@Override
	public String getMail() {
		return mail;
	}

	@Override
	public String getType() {
		return TYPE;
	}

	@Override
	public int getMemory() {
		return memory;
	}

	@Override
	public void addFile(String file, int size) {
		files[counter++] = new FilesClass(file, size);
		memory -= size;
	}

	@Override
	public int getFileSize(int index) {
		return files[index].getSize();
	}

	@Override
	public void shareFile(String file, String name, String owner, int size) {
		files[counter] = new FilesClass(file, size);
		files[counter++].share(owner);
		memory -= size / 2;
	}

	@Override
	public boolean sharedFile(String name) {
		return searchByName(name) != -1;
	}

	@Override
	public int searchByName(String name) {
		int finalpos = -1;
		int pos = 0;
		while (finalpos == -1 && pos < counter) {
			if (files[pos].getName().equals(name))
				finalpos = pos;
			else
				pos++;
		}
		return finalpos;
	}

	@Override
	public int searchByNameShare(String file, String owner) {
		int finalpos = -1;
		int pos = counter - 1;
		while (finalpos == -1 && pos >= 0) {
			if (files[pos].getName().equals(file) && files[pos].shared() && files[pos].getOwner().equals(owner))
				finalpos = pos;
			else
				pos--;
		}
		return finalpos;
	}

	protected int invSearchByName(String name) {
		int finalpos = -1;
		int pos = counter - 1;
		while (finalpos == -1 && pos >= 0) {
			if (files[pos].getName().equals(name))
				finalpos = pos;
			else
				pos--;
		}
		return finalpos;
	}

	@Override
	public void initialiseFilesIterator() {
		iterator = new IteratorClass(files, counter);
	}

	@Override
	public boolean hasNextFile() {
		return iterator.hasNext();
	}

	@Override
	public Files nextFile() {
		return iterator.nextFile();
	}
}