/**
 * 
 */
package cloud;

/**
 * @author 53298
 *
 */
public interface Cloud {

	static final int CAPATICY_ACCOUNTS = 100;
	static final String TYPE_BASIC = "Basic";

	/**
	 * adds account
	 * 
	 * @param mail
	 * @param type
	 * @return true/false
	 */
	boolean addAccount(String mail, String type);

	/**
	 * uploads a file to an account
	 * 
	 * @param mail
	 * @param file
	 * @param size
	 * @return 0: success, 1: account does not exist, 2: file already exists in the
	 *         account, 3: file size exceeds capacity
	 */
	int uploadFile(String mail, String file, int size);

	/**
	 * shares a file between accounts
	 * 
	 * @param mail1
	 * @param mail2
	 * @param file
	 * @return 0: success, 1: account does not exist, 2: file does not exist, 3:
	 *         basic account problem, 4: file aready shared, 5: dimensio problem
	 */
	int fileShare(String mail1, String mail2, String file);

	/**
	 * updates a file
	 * 
	 * @param mail1
	 * @param mail2
	 * @param file
	 * @return
	 */
	// int fileUpdate(String mail1, String mail2, String file);

	/**
	 * last update
	 * 
	 * @return
	 */
	// int lastFileUpdate();

	/**
	 * searches account by mail
	 * 
	 * @param mail
	 * @return index
	 */
	int searchByMail(String mail);

	/**
	 * initialises accounts iterator
	 */
	void initialiseAccountsIterator();

	/**
	 * checks if there are more accounts in the array
	 * 
	 * @return true/false
	 */
	boolean hasNextAccount();

	/**
	 * gets next account
	 * 
	 * @return account
	 */
	Accounts nextAccount();

	/**
	 * initialises files iterator
	 */
	void initialiseFilesIterator(String mail);

	/**
	 * checks if there are more files in the array
	 * 
	 * @return true/false
	 */
	boolean hasNextFile(String mail);

	/**
	 * gets next file in the array
	 * 
	 * @return file
	 */
	Files nextFile(String mail);
}