#include "mmu.h"
#include "so.h"
#include "tlb.h"


/* Tabela de paginas (relaciona pagina->frame) inicializada com todas as
 * entradas invalidas
 */
pagetable_entry pageTable[MAX_VIRTUAL_PAGES];



void initMMU(int tlbsz) {
    initTLB(tlbsz);
    // pageTable ja' esta' inicializada c/ zeros
}


/* descobre o frame em memoria para a pagina virtual indicada.
 * Usa primeiro a TLB como cache da tabela de paginas em memoria. Em caso
 * de miss, consulta tab pag e, se e' valida, atualiza TLB, trocando entradas
 * se necessario.
 */
int page2frame(int page) {
    int frame = findTLB(page);
    if (frame == -1) { // TLB miss
        /* consultar tabela de paginas em RAM */
        if (!pageTable[page].valid) { /* pagina nao mapeada em frame de RAM */
            /*** page fault -> interrupt: invocar o SO
             *** o SO acrescenta memoria ao processo ou aborta-o */
            pageFault(page, pageTable, MAX_VIRTUAL_PAGES);
        }

        frame = pageTable[page].frame;
        addTLB(page, frame); /* acrescentar na TLB */
    }

    return frame;
}

unsigned int translateOneAddr(unsigned int addr, char rw) {
    /* converte endereco virtual para endereco real (fisico) */
    int page;
    int frame;
    int realAddress;
    // TODO: converter end virtual para real



           
    realAddress = 0;                      
    return realAddress;
}
