
#ifndef MMU_H
#define MMU_H

/*
Assume-se que:
 - o CPU tem 32 bits de enderecos virtuais e tambem reais
   paginas de 4K (2^12) logo sao 12 bits para o deslocamento e
   sobram 20 bits para o num da pagina
 - logo o no. max de entradas da tabela de paginas e´ 2^20=1024*1024
*/


#define PAGESIZE (4*1024)	 // 4KBytes
#define MAX_VIRTUAL_PAGES (1024*1024)	 // equiv. 4GBytes

/* Tipo base de cada elemento da tabela de paginas.
 * Define que cada "objeto" tem os dois atributos indicados:
 */
typedef struct {
    unsigned int frame;
    int valid;
} pagetable_entry;



/* inicia MMU com o numero de paginas na TLB a simular */
extern void initMMU( int tlbsz );

/* simula a transformacao de um endereco virtual em real */
extern unsigned int translateOneAddr(unsigned int addr, char rw);


#endif
