#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "mmu.h"
#include "so.h"
#include "stats.h"

int verbose = 0;

void simulateAllTheSteps(FILE *tf) {
    unsigned Vaddr, Raddr;
    char rw;

    while (fscanf(tf, "%x %c", &Vaddr, &rw) == 2) {
        Raddr = translateOneAddr(Vaddr, rw); // traduzir endereco V em R

        /* show read/write mem at Raddr */
        if (verbose)
            printf("%x %c\n", Raddr, rw);
    }
}

int main(int argc, char *argv[]) {
    FILE *traceFile;
    int tlbsz;
    int ch;
    char *prog = argv[0];

    if (argc > 1 && strcmp(argv[1], "-v") == 0) {
        verbose = 1;
        argc--;
        argv++;
    }
    if (argc < 2 || argc > 3) {
        /* Garantir que foram passados 1 ou 2 argumentos
           na linha de comando (para alem do nome do programa) */ 
        printf("%s [-v] tlb-size [tracefile] \n", prog);
        return 1;
    }

    /* numero de entradas de paginas na TLB a simular*/
    tlbsz = atoi(argv[1]);
    if (tlbsz == 0) {
        printf("TLB size is zero?!\n");
        exit(1);
    }
    if (argc == 2)
        traceFile = stdin;
    else if ((traceFile = fopen(argv[2], "r")) == NULL) {
        printf("Trace-file '%s' error\n", argv[2]);
        exit(1);
    }

    /* Corpo do programa */
    initStats();
    initMMU(tlbsz);
    simulateAllTheSteps(traceFile);
    printStats(argc == 2 ? "stdin" : argv[2]);

    return 0;
}
