
#include <stdio.h>

#include "so.h"
#include "tlb.h"


/* max real mem: */
#define REAL_MEM   (8*1024*1024)	// 8MBytes
#define MAX_FRAMES (REAL_MEM/PAGESIZE)


/* Tipo base da tabela de frames (paginas fisicas) */
//comeca com todas invalidas
typedef struct {
    int page;
    int valid;
    int dirty;
    //int lastref;
} frametable_entry;

/* Tabela de frames (indica quais estao em uso ou livres) inicializada a "todas as frames livres" */
frametable_entry frameTable[MAX_FRAMES];

int numberOfPagesWritten;
int numberOfPageFaults;




static int getFreeFrame(void) {
    /* devolve a primeira frame livre.
     devolve -1 se nao ha' nenhuma livre (toda a memoria ocupada)
     */
    int i;

    for (i = 0; i < MAX_FRAMES; i++)
        if (frameTable[i].valid == 0)
            return i;
    return -1;
}

static int selectVictimLRU(void) {
    /* estrategia de substituicao de paginas
     */
    int victim=0;
    // not implemented!
    printf("selectVictimLRU (so.c)  isto nao devia acontecer!!!\n");
    return victim;
}

static int findPage(int frameToUse) {
    /* retorna o num da pagina carregada numa frame que e' dada como argumento;
     so' e' chamada para frames que tem uma pagina carregada
     */
    return frameTable[frameToUse].page;
}

void pageFault(int page, pagetable_entry pageTable[], int pageTableSZ) {
    int new_frame, victim;

    numberOfPageFaults++;
    
    new_frame = getFreeFrame(); /* tenta obter uma frame livre */

    if (new_frame == -1) {
        /* nao havia frames livres - chamar um algoritmo de substituicao
         de paginas para escolher a frame que vai ser ocupada */
        new_frame = selectVictimLRU();
        victim = findPage(new_frame);

        if (frameTable[new_frame].dirty)
            numberOfPagesWritten++; // swapped out

        delTLB(victim);
        /* actualiza tabela de paginas  */
        pageTable[victim].valid = 0;
    }

    /* actualiza tabela de paginas */
    pageTable[page].frame = new_frame;
    pageTable[page].valid = 1;

    /* actualiza tabela de frames */
    frameTable[new_frame].page = page;
    frameTable[new_frame].valid = 1;
    frameTable[new_frame].dirty = 0;
    //frameTable[new_frame].lastref = 0; // not implemented
}
