
#include <stdio.h>

#include "stats.h"

extern unsigned clock;

int tlbmiss;
int tlbvictim;

void initStats(void) {
    tlbmiss = 0;
    tlbvictim = 0;
}

void addTLBmiss() { tlbmiss++; }
void addTLBvictim() { tlbvictim++; }

void printStats(const char *tracefile) {
    if (tracefile == NULL)
        printf("INPUT FILE = stdin\n");
    else
        printf("INPUT FILE = %s\n", tracefile);
    printf("number of memory references = %u \n", clock);

    printf("number TLB misses = %u\n", tlbmiss);
    printf("number of TLB victims = %u\n", tlbvictim);

    printf("TLB hitratio = %.1f%%\n", 100.0 * (1.0 - ((double)tlbmiss / clock)));
}
