
#include <stdlib.h>
#include <stdio.h>

#include "tlb.h"
#include "stats.h"

#define MAX_TLB     1024    // tamanho maximo que pode ser simulado

/* TLB como uma cache associativa pura de paginas */
/* Vetor de estruturas. Este e' como um vetor de "objetos"
 * com os atributos indicados:
 */
struct tlb_entry {
    int valid;            // 1 se entrada e' valida.
    unsigned int page;    // Numero da pagina.
    unsigned int frame;   // Numero da frame associada a pagina.
    unsigned int lastref; // Instante do ultimo acesso.  Tem de ser atualizado em cada acesso.
} TLB[MAX_TLB];

// tamanho da TLB a simular (nao usa todo o vetor declarado)
int TLBsize;

/* logical clock */
unsigned int clock;


/* inicia a TLB com tamanho tlbsize */
void initTLB( int tlbsize ) {
    /* so' TLBsize entradas do vetor TLB serao usadas */
    if ( tlbsize>MAX_TLB ) {
        fprintf(stderr,"TLB size to big!\n");
        exit(2);
    }
    TLBsize = tlbsize;
}

static int findFree() {
    /* verificar se existe uma entrada na TLB livre para uma nova pagina */
    int i;
    for ( i=0; i< TLBsize; i++ )
        if ( TLB[i].valid==0 ) return i;
    return -1;
}

static int findVictim() {
    /* escolher entrada a ser removida para dar a uma nova pagina */
    int victim=0;
    // TODO -- Selecionar a entrada da TBL que está à mais tempo sem ser utilizada (LRU)
   



    return victim;
}



int findTLB( int page ) {
    /* cada acesso a TLB e' para um acesso a memoria e avanca o nosso "relogio" */
    clock++;

    /* procurar a frame para a pagina indicada. Esta busca no hardware seria
     * em paralelo usando memoria associativa ou, para TLB maiores, numa
     * organizacao associativa por conjuntos (grupos) como nas caches
     */

    // TODO -- Procurar a pagina na TLB e caso encontre devolve o frame respectivo
    //         (atualiza tambem lastref respetivo)
    return clock;  // remover esta linha




    // Se nao encontrou a pagina na TLB:
    addTLBmiss();
    return -1;
}


void addTLB( int page, int frame ) {
    /* acrescentar pagina a TLB (se necessario remover outra entrada) */
    int line = findFree();

    if ( line == -1 ) {
        line = findVictim();
        addTLBvictim();
    }

    TLB[line].valid = 1;
    TLB[line].page = page;
    TLB[line].frame = frame;
    // atualiza lastref
    TLB[line].lastref = clock;
}


void delTLB( int page ) {
    /* apagar pagina da TLB */
    for ( int i=0; i< TLBsize; i++ )
        if ( TLB[i].valid && TLB[i].page == page ) {
            TLB[i].valid = 0;
            return;
        }
}
