import java.util.*;
import java.io.*;

class Board {
	private static final int SIZE = 9;
	private static final int SQUARE = SIZE/3;
	private static final Random randAllowed_ = new Random();
	private static final Random randAvailable_ = new Random();
	
	private int [][] board_;
	private int r_, c_;
	private Vector<Integer> allowed_;
	private Vector<Pair<Integer,Integer>> available_;
	
	
	public Board(){
		board_ = new int[SIZE][SIZE];
		r_ = c_ = -1;
		allowed_ = new Vector<Integer>();
	}
	
	public Board(Board other){
		board_ = new int[SIZE][SIZE];
		for(int i = 0; i < SIZE; i++)
			for(int j = 0; j< SIZE; j++)
				board_[i][j] = other.board_[i][j];
		r_ = c_ = -1;
	}
	
	public void Read(String fileName){
		try {
			InputStream stream = new FileInputStream(fileName);
			InputStreamReader stdin = new InputStreamReader(stream);
			BufferedReader console = new BufferedReader(stdin);
			String s;
			for(int i = 0; i < SIZE; i++) {
				s = console.readLine();
				for(int j = 0; j < SIZE; j++)
					if(s.charAt(j) != '.')
						board_[i][j] = s.charAt(j)-'0';
			}
		}
		catch (IOException ioex) {
			System.err.println("Input error: "+ioex.getMessage());
			System.exit(1);
		}
	}
	
	public boolean hasPosition(){
		if(available_ == null) {
			available_ = new Vector<Pair<Integer,Integer>>();
			for(int i = 0; i < SIZE; i++)
				for(int j = 0; j < SIZE; j++)
					if(board_[i][j] == 0)
						available_.addElement(new Pair<Integer, Integer>(i,j));
		}
		return !available_.isEmpty();
	}
	
	public int howManyAllowed(Pair<Integer,Integer> p){
		Vector<Integer> allowed = new Vector<Integer>();
		for(int i = 1; i <= SIZE; i++)
			allowed.addElement(i);
		for(int i = 0; i < SIZE; i++)
			if(board_[p.first()][i] != 0)
				allowed.removeElement(board_[p.first()][i]);
		for(int i = 0; i < SIZE; i++)
			if(board_[i][p.second()] != 0)
				allowed.removeElement(board_[i][p.second()]);
		for(int i = 0; i < SQUARE; i++)
			for(int j = 0; j < SQUARE; j++){
				int rr = p.first()/SQUARE*SQUARE+i;
				int cc = p.second()/SQUARE*SQUARE+j;
				if(board_[rr][cc] != 0)
					allowed.removeElement(board_[rr][cc]);
				}
		return allowed.size();
	}
	
	public void nextPosition(){
		int best = 10;
		List<Integer> indexes = new Vector<Integer>();
		for(int i = 0; i < available_.size(); i++){
			Pair<Integer, Integer> p = available_.elementAt(i);
			int n = howManyAllowed(p);
			if(n < best){
				indexes.clear();
				indexes.add(i);
				best = n;
			} else if (n == best)
				indexes.add(i);
		}
		Pair<Integer, Integer> p = available_.elementAt(indexes.get(randAvailable_.nextInt(indexes.size())));
		r_ = p.first();
		c_ = p.second();
	}
	
	public boolean hasOptions(){
		if(allowed_ == null){
			allowed_ = new Vector<Integer>();
			for(int i = 1; i<= SIZE; i++)
				allowed_.addElement(i);
			for(int i = 0; i < SIZE; i++)
				if(board_[r_][i] != 0)
					allowed_.removeElement(board_[r_][i]);
			for(int i = 0; i < SIZE; i++)
				if(board_[i][c_] != 0)
					allowed_.removeElement(board_[i][c_]);
			for(int i = 0; i < SQUARE; i++)
				for(int j = 0; j < SQUARE; j++){
					int rr = r_/SQUARE*SQUARE+i;
					int cc = c_/SQUARE*SQUARE+j;
					if(board_[rr][cc] != 0)
						allowed_.removeElement(board_[rr][cc]);
				}
		}
		return !allowed_.isEmpty();
	}
	
	public void nextOption(){
		board_[r_][c_] = allowed_.get(randAllowed_.nextInt(allowed_.size()));
		allowed_.removeElement(board_[r_][c_]);
	}
	
	public void println(){
		for(int i = 0; i < SIZE; i++){
			for(int j = 0; j < SIZE; j++)
				if(board_[i][j] != 0)
					System.out.print(board_[i][j]);
				else System.out.print(".");
			System.out.println();
		}
	}
}