import java.util.Stack;

public class Sudoku {

	public static void main(String[] args) {
		Stack<Board> boardStack = new Stack<Board>();
		Board init = new Board();
		if(args.length != 1){
			System.err.println("Syntax: java Sudoku inputFile");
			return;
		}
		init.Read(args[0]);
		boardStack.push(init);
		for(;;){
			Board b = new Board(boardStack.peek());
			if(b.hasPosition()){
				b.nextPosition();
				if(b.hasOptions()){
					b.nextOption();
					boardStack.push(b);
				} else {
					while(!boardStack.isEmpty() && !boardStack.peek().hasOptions())
						boardStack.pop();
					if(boardStack.empty())
						break;
					else boardStack.peek().nextPosition();
				}
			}
			else {
				b.println();
				break;
			}
		}
	}
}
