clear all;
close all;
clc;

% Load data and find unique feature values 
% (this is only valid for discrete NB);
data=loaddata('agaricus-lepiota.data');
classes=data(:,1);
data=data(:,2:end);
feats = unique(data);

% Split eatable and poisonous data
ix_e = find(classes=='e');
ix_p = find(classes=='p');
data_p = data(ix_p,:);
data_e = data(ix_e,:);

% Make random permutation 
% and split train/test eatable data
data_e = data_e(randperm(length(data_e)),:);
eTest = data_e(1:floor(length(data_e)/2),:);
eTrain = data_e(ceil(length(data_e)/2):end,:);

% Make random permutation 
% and split train/test poisonous data
data_p = data_p(randperm(length(data_p)),:);
pTest = data_p(1:floor(length(data_p)/2),:);
pTrain = data_p(ceil(length(data_p)/2):end,:);

% Report data split
totTrain=size(eTrain,1)+size(pTrain,1);
totTest=size(eTest,1)+size(pTest,1);
fprintf('Training set: %i examples\n',totTrain);
fprintf('Test set: %i examples\n',totTest);

% Learn NB parameters for Eatable class
eatable_bayes.logPrior=log([size(eTrain,1)/totTrain]);
eatable_bayes.pdm=nb_learn(eTrain,feats,1e-16);

% Learn NB parameters for Poisonois class
poisonous_bayes.logPrior=log([size(pTrain,1)/totTrain]);
poisonous_bayes.pdm=nb_learn(pTrain,feats,1e-16);

% Test eatable mushrooms
eatable_hypothesis = nb_probability(eTest, feats,eatable_bayes);
poisonous_hypothesis = nb_probability(eTest, feats,poisonous_bayes);

e_test_labels = sum(eatable_hypothesis > poisonous_hypothesis);

% Test poisonous mushrooms
eatable_hypothesis = nb_probability(pTest, feats,eatable_bayes);
poisonous_hypothesis = nb_probability(pTest, feats,poisonous_bayes);

p_test_labels = sum(eatable_hypothesis < poisonous_hypothesis);

% Output resutls
fprintf('\nEatable detection precision: %2.1f%%\n',100*e_test_labels/(length(eTest)));
fprintf('Eatable missclassified: %d\n',length(eTest)-e_test_labels);
fprintf('\nPoisonous detection precision: %2.1f%%\n',100*p_test_labels/(length(pTest)));
fprintf('Poisonous missclassified: %d\n',length(pTest)-p_test_labels);
